/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.celeborn.common.network.protocol.Encoders;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class RpcFailure
extends ResponseMessage {
    public final long requestId;
    public final String errorString;

    public RpcFailure(long requestId, String errorString) {
        this.requestId = requestId;
        this.errorString = errorString;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RPC_FAILURE;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.Strings.encodedLength(this.errorString);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        Encoders.Strings.encode(buf, this.errorString);
    }

    public static RpcFailure decode(ByteBuf buf) {
        long requestId = buf.readLong();
        String errorString = Encoders.Strings.decode(buf);
        return new RpcFailure(requestId, errorString);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.errorString);
    }

    public boolean equals(Object other) {
        if (other instanceof RpcFailure) {
            RpcFailure o = (RpcFailure)other;
            return this.requestId == o.requestId && this.errorString.equals(o.errorString);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("requestId", this.requestId).append("errorString", (Object)this.errorString).toString();
    }
}

