/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogUtils {
    public static final Logger LOG = LoggerFactory.getLogger(LogUtils.class);

    public static <THROWABLE extends Throwable> void runAndLog(Logger log, CheckedRunnable<THROWABLE> op, Supplier<String> opName) throws THROWABLE {
        try {
            op.run();
        }
        catch (Throwable t) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to " + opName.get(), t);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to " + opName.get() + ": " + t);
            }
            throw t;
        }
        if (log.isTraceEnabled()) {
            log.trace("Successfully ran " + opName.get());
        }
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT supplyAndLog(Logger log, CheckedSupplier<OUTPUT, THROWABLE> supplier, Supplier<String> name) throws THROWABLE {
        OUTPUT output;
        try {
            output = supplier.get();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to " + name.get(), (Throwable)e);
            } else if (log.isWarnEnabled()) {
                log.warn("Failed to " + name.get() + ": " + e);
            }
            Throwable throwable = (Throwable)JavaUtils.cast(e);
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Successfully supplied " + name.get() + ": " + output);
        }
        return output;
    }

    public static Runnable newRunnable(final Logger log, final Runnable runnable, final Supplier<String> name) {
        return new Runnable(){

            @Override
            public void run() {
                LogUtils.runAndLog(log, runnable::run, name);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public static <T> Callable<T> newCallable(final Logger log, final Callable<T> callable, final Supplier<String> name) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LogUtils.supplyAndLog(log, callable::call, name);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public static <OUTPUT, THROWABLE extends Throwable> CheckedSupplier<OUTPUT, THROWABLE> newCheckedSupplier(final Logger log, final CheckedSupplier<OUTPUT, THROWABLE> supplier, final Supplier<String> name) {
        return new CheckedSupplier<OUTPUT, THROWABLE>(){

            @Override
            public OUTPUT get() throws Throwable {
                return LogUtils.supplyAndLog(log, supplier, name);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public static void warn(Logger log, Supplier<String> message, Throwable t, Class<?> ... exceptionClasses) {
        if (log.isWarnEnabled()) {
            if (ReflectionUtils.isInstance(t, exceptionClasses)) {
                log.warn(message.get() + ": " + t);
            } else {
                log.warn(message.get(), t);
            }
        }
    }

    public static void infoOrTrace(Logger log, String message, Throwable t) {
        LogUtils.infoOrTrace(log, () -> message, t);
    }

    public static void infoOrTrace(Logger log, Supplier<String> message, Throwable t) {
        if (log.isTraceEnabled()) {
            log.trace(message.get(), t);
        } else if (log.isInfoEnabled()) {
            log.info("{}: {}", (Object)message.get(), (Object)String.valueOf(t));
        }
    }
}

