/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.util.Utils$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CelebornHadoopUtils$
implements Logging {
    public static CelebornHadoopUtils$ MODULE$;
    private AtomicBoolean logPrinted;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CelebornHadoopUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        CelebornHadoopUtils$ celebornHadoopUtils$ = this;
        synchronized (celebornHadoopUtils$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private AtomicBoolean logPrinted() {
        return this.logPrinted;
    }

    private void logPrinted_$eq(AtomicBoolean x$1) {
        this.logPrinted = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(CelebornConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        if (new StringOps(Predef$.MODULE$.augmentString(conf.hdfsDir())).nonEmpty()) {
            Path path = new Path(conf.hdfsDir());
            String scheme = path.toUri().getScheme();
            String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
            hadoopConf.set("dfs.replication", "2");
            hadoopConf.set(disableCacheName, "false");
            if (this.logPrinted().compareAndSet(false, true)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(261).append("Celeborn overrides some HDFS settings defined in Hadoop configuration files, ").append("including '").append(disableCacheName).append("=false' and 'dfs.replication=2'. ").append("It can be overridden again in Celeborn configuration with the additional ").append("prefix 'celeborn.hadoop.', e.g. 'celeborn.hadoop.dfs.replication=3'").toString());
            }
        }
        this.appendSparkHadoopConfigs(conf, hadoopConf);
        return var2_2;
    }

    private void appendSparkHadoopConfigs(CelebornConf conf, Configuration hadoopConf) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornHadoopUtils$.$anonfun$appendSparkHadoopConfigs$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornHadoopUtils$.$anonfun$appendSparkHadoopConfigs$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            CelebornHadoopUtils$.$anonfun$appendSparkHadoopConfigs$3(hadoopConf, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public FileSystem getHadoopFS(CelebornConf conf) {
        Configuration hadoopConf = this.newConfiguration(conf);
        this.initKerberos(conf, hadoopConf);
        return new Path(conf.hdfsDir()).getFileSystem(hadoopConf);
    }

    public void deleteHDFSPathOrLogError(FileSystem hadoopFs, Path path, boolean recursive) {
        try {
            long startTime = System.currentTimeMillis();
            hadoopFs.delete(path, recursive);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Delete HDFS ").append(path).append("(recursive=").append(recursive).append(") costs ").append(Utils$.MODULE$.msDurationToString(System.currentTimeMillis() - startTime)).toString());
        }
        catch (IOException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to delete HDFS ").append(path).append("(recursive=").append(recursive).append(") due to: ").toString(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initKerberos(CelebornConf conf, Configuration hadoopConf) {
        UserGroupInformation.setConfiguration((Configuration)hadoopConf);
        if (!"kerberos".equals(hadoopConf.get("hadoop.security.authentication").toLowerCase())) return;
        Tuple2 tuple2 = new Tuple2(conf.hdfsStorageKerberosPrincipal(), conf.hdfsStorageKerberosKeytab());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String principal = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String keytab = (String)some2.value();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempting to login to Kerberos using principal: ").append(principal).append(" and keytab: ").append(keytab).toString());
                    if (!new File(keytab).exists()) {
                        throw new CelebornException(new StringBuilder(28).append("Keytab file: ").append(keytab).append(" does not exist").toString());
                    }
                    UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Kerberos is enabled without principal and keytab supplied, assuming keytab is managed externally");
        UserGroupInformation.getCurrentUser();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("celeborn.hadoop.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHadoopConfigs$3(Configuration hadoopConf$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$1.set(key.substring("celeborn.hadoop.".length()), value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private CelebornHadoopUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.logPrinted = new AtomicBoolean(false);
    }
}

