/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.ResponseMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;

public final class RpcResponse
extends ResponseMessage {
    public final long requestId;

    public RpcResponse(long requestId, ManagedBuffer message) {
        super(message);
        this.requestId = requestId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RPC_RESPONSE;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeInt((int)this.body().size());
    }

    @Override
    public ResponseMessage createFailureResponse(String error) {
        return new RpcFailure(this.requestId, error);
    }

    public static RpcResponse decode(ByteBuf buf) {
        return RpcResponse.decode(buf, true);
    }

    public static RpcResponse decode(ByteBuf buf, boolean decodeBody) {
        long requestId = buf.readLong();
        buf.readInt();
        if (decodeBody) {
            return new RpcResponse(requestId, new NettyManagedBuffer(buf));
        }
        return new RpcResponse(requestId, NettyManagedBuffer.EmptyBuffer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestId, this.body()});
    }

    public boolean equals(Object other) {
        if (other instanceof RpcResponse) {
            RpcResponse o = (RpcResponse)other;
            return this.requestId == o.requestId && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("requestId", this.requestId).add("body", (Object)this.body()).toString();
    }
}

