/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.network;

import com.google.common.base.Strings;
import java.io.Serializable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.util.CelebornHadoopUtils$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0003\u0006\u00013!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006C\u0003.\u0001\u0011\u0005a\u0006C\u00043\u0001\t\u0007I\u0011B\u001a\t\rq\u0002\u0001\u0015!\u00035\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015i\u0004\u0001\"\u0001P\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015y\u0006\u0001\"\u0001a\u0005Q\u0019U\r\\3c_Jt'+Y2l%\u0016\u001cx\u000e\u001c<fe*\u00111\u0002D\u0001\b]\u0016$xo\u001c:l\u0015\tia\"\u0001\u0004nCN$XM\u001d\u0006\u0003\u001fA\ta\u0001Z3qY>L(BA\t\u0013\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0005\u000b\u0002\u0011\r,G.\u001a2pe:T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0011%tG/\u001a:oC2T!!\n\n\u0002\r\r|W.\\8o\u0013\t9#EA\u0004M_\u001e<\u0017N\\4\u0002\u0019\r,G.\u001a2pe:\u001cuN\u001c4\u0011\u0005)ZS\"\u0001\u0013\n\u00051\"#\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u00020cA\u0011\u0001\u0007A\u0007\u0002\u0015!)\u0001F\u0001a\u0001S\u0005\u0011BM\\:U_N;\u0018\u000e^2i\u001b\u0006\u0004\b/\u001b8h+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\rqW\r\u001e\u0006\u0003sQ\ta\u0001[1e_>\u0004\u0018BA\u001e7\u0005I!ej\u0015+p'^LGo\u00195NCB\u0004\u0018N\\4\u0002'\u0011t7\u000fV8To&$8\r['baBLgn\u001a\u0011\u0002\u000fI,7o\u001c7wKR\u0011qH\u0011\t\u0003k\u0001K!!\u0011\u001c\u0003\t9{G-\u001a\u0005\u0006\u0007\u0016\u0001\r\u0001R\u0001\tQ>\u001cHOT1nKB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u000f\u000e\u0003!S!!\u0013\r\u0002\rq\u0012xn\u001c;?\u0013\tYE$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&\u001d)\t\u0001\u0016\fE\u0002R-~r!A\u0015+\u000f\u0005\u001d\u001b\u0016\"A\u000f\n\u0005Uc\u0012a\u00029bG.\fw-Z\u0005\u0003/b\u00131aU3r\u0015\t)F\u0004C\u0003[\r\u0001\u00071,A\u0005i_N$h*Y7fgB\u0019\u0011K\u0016#\u0002\u0017\r|'/\u001a*fg>dg/\u001a\u000b\u0003!zCQAW\u0004A\u0002m\u000bA\"[:P]N\u000bW.\u001a*bG.$2!\u00193g!\tY\"-\u0003\u0002d9\t9!i\\8mK\u0006t\u0007\"B3\t\u0001\u0004!\u0015a\u00039sS6\f'/\u001f%pgRDQa\u001a\u0005A\u0002\u0011\u000b1B]3qY&\u001c\u0017\rS8ti\u0002")
public class CelebornRackResolver
implements Logging {
    private final DNSToSwitchMapping dnsToSwitchMapping;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        CelebornRackResolver celebornRackResolver = this;
        synchronized (celebornRackResolver) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private DNSToSwitchMapping dnsToSwitchMapping() {
        return this.dnsToSwitchMapping;
    }

    public Node resolve(String hostName) {
        return (Node)this.coreResolve((Seq<String>)((Seq)new .colon.colon((Object)hostName, (List)Nil$.MODULE$))).head();
    }

    public Seq<Node> resolve(Seq<String> hostNames) {
        return this.coreResolve(hostNames);
    }

    private Seq<Node> coreResolve(Seq<String> hostNames) {
        if (hostNames.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        ArrayBuffer nodes = new ArrayBuffer();
        Buffer rNameList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.dnsToSwitchMapping().resolve((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)hostNames.toList()).asJava())).asScala();
        if (rNameList == null || rNameList.isEmpty()) {
            hostNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> nodes.$plus$eq((Object)new NodeBase(x$1, "/default-rack")));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Got an error when resolving hostNames. ").append("Falling back to ").append("/default-rack").append(" for all").toString());
        } else {
            ((TraversableLike)hostNames.zip((GenIterable)rNameList, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CelebornRackResolver.$anonfun$coreResolve$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ArrayBuffer arrayBuffer;
                Tuple2 tuple2 = x$2;
                if (tuple2 != null) {
                    String hostName = (String)tuple2._1();
                    String rName = (String)tuple2._2();
                    if (Strings.isNullOrEmpty((String)rName)) {
                        nodes.$plus$eq((Object)new NodeBase(hostName, "/default-rack"));
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Could not resolve ").append(hostName).append(". ").append("Falling back to ").append("/default-rack").toString());
                        arrayBuffer = BoxedUnit.UNIT;
                    } else {
                        arrayBuffer = nodes.$plus$eq((Object)new NodeBase(hostName, rName));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                ArrayBuffer arrayBuffer2 = arrayBuffer;
                return arrayBuffer2;
            });
        }
        return nodes.toList();
    }

    public boolean isOnSameRack(String primaryHost, String replicaHost) {
        boolean bl;
        Node primaryNode = this.resolve(primaryHost);
        Node replicaNode = this.resolve(replicaHost);
        if (primaryNode == null || replicaNode == null) {
            bl = false;
        } else {
            String string = primaryNode.getNetworkLocation();
            String string2 = replicaNode.getNetworkLocation();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$coreResolve$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public CelebornRackResolver(CelebornConf celebornConf) {
        CachedDNSToSwitchMapping cachedDNSToSwitchMapping;
        Logging.$init$((Logging)this);
        Configuration conf = CelebornHadoopUtils$.MODULE$.newConfiguration(celebornConf);
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        DNSToSwitchMapping dNSToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)dnsToSwitchMappingClass, (Configuration)conf);
        CachedDNSToSwitchMapping cachedDNSToSwitchMapping2 = dNSToSwitchMapping instanceof CachedDNSToSwitchMapping ? (cachedDNSToSwitchMapping = (CachedDNSToSwitchMapping)dNSToSwitchMapping) : new CachedDNSToSwitchMapping(dNSToSwitchMapping);
        this.dnsToSwitchMapping = cachedDNSToSwitchMapping2;
    }
}

