/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.dbutil;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.objectstyle.ashwood.dbutil.Column;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.PrimaryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Serializable {
    private String catalog;
    private String schema;
    private String name;
    private Collection<Column> columns = new ArrayList<Column>(1);
    private Collection<ForeignKey> foreignKeys = new ArrayList<ForeignKey>(1);
    private Collection<PrimaryKey> primaryKeys = new ArrayList<PrimaryKey>(1);

    public Table() {
    }

    public Table(String catalog, String schema, String name) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setName(name);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name != null ? this.name : "";
    }

    public static String composeFullName(String catalog, String schema, String tableName) {
        StringBuilder buffer = new StringBuilder();
        if (catalog != null) {
            buffer.append(catalog).append('.');
        }
        if (schema != null) {
            buffer.append(schema).append('.');
        }
        if (tableName != null) {
            buffer.append(tableName);
        }
        return buffer.toString();
    }

    public String getFullName() {
        return Table.composeFullName(this.catalog, this.schema, this.name);
    }

    public void refreshColumns(DatabaseMetaData metaData) throws SQLException {
        this.columns.clear();
        ResultSet rs = null;
        try {
            rs = metaData.getColumns(this.catalog, this.schema, this.name, null);
            while (rs.next()) {
                Column column = new Column();
                this.columns.add(column);
                column.setOwner(this);
                column.setName(rs.getString("COLUMN_NAME"));
                column.setDataType(rs.getInt("DATA_TYPE"));
                column.setTypeName(rs.getString("TYPE_NAME"));
                column.setSize(rs.getInt("COLUMN_SIZE"));
                column.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                column.setRadix(rs.getInt("NUM_PREC_RADIX"));
                column.setNullable(rs.getInt("NULLABLE"));
                column.setRemarks(rs.getString("REMARKS"));
                column.setDefaultValue(rs.getString("COLUMN_DEF"));
                column.setCharOctetLength(rs.getInt("CHAR_OCTET_LENGTH"));
                column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public void refreshPrimaryKeys(DatabaseMetaData metaData) throws SQLException {
        this.primaryKeys.clear();
        ResultSet rs = null;
        try {
            rs = metaData.getPrimaryKeys(this.catalog, this.schema, this.name);
            while (rs.next()) {
                PrimaryKey pk = new PrimaryKey();
                this.primaryKeys.add(pk);
                pk.setOwner(this);
                pk.setColumnName(rs.getString("COLUMN_NAME"));
                pk.setKeySequence(rs.getShort("KEY_SEQ"));
                pk.setName(rs.getString("PK_NAME"));
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public void refreshForeignKeys(DatabaseMetaData metaData) throws SQLException {
        this.foreignKeys.clear();
        ResultSet rs = null;
        try {
            rs = metaData.getImportedKeys(this.catalog, this.schema, this.name);
            while (rs.next()) {
                ForeignKey fk = new ForeignKey();
                this.foreignKeys.add(fk);
                fk.setOwner(this);
                fk.setPkTableCatalog(rs.getString("PKTABLE_CAT"));
                fk.setPkTableSchema(rs.getString("PKTABLE_SCHEM"));
                fk.setPkTableName(rs.getString("PKTABLE_NAME"));
                fk.setPkColumnName(rs.getString("PKCOLUMN_NAME"));
                fk.setColumnName(rs.getString("FKCOLUMN_NAME"));
                fk.setKeySequence(rs.getShort("KEY_SEQ"));
                fk.setUpdateRule(rs.getShort("UPDATE_RULE"));
                fk.setDeleteRule(rs.getShort("DELETE_RULE"));
                fk.setName(rs.getString("FK_NAME"));
                fk.setPkName(rs.getString("PK_NAME"));
                fk.setDeferrability(rs.getShort("DEFERRABILITY"));
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
    }

    public void refresh(DatabaseMetaData metaData) throws SQLException {
        this.refreshColumns(metaData);
        this.refreshPrimaryKeys(metaData);
        this.refreshForeignKeys(metaData);
    }

    public Collection<PrimaryKey> getPrimaryKeys() {
        return Collections.unmodifiableCollection(this.primaryKeys);
    }

    public Collection<ForeignKey> getForeignKeys() {
        return Collections.unmodifiableCollection(this.foreignKeys);
    }

    public Collection<Column> getColumns() {
        return Collections.unmodifiableCollection(this.columns);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
        column.setOwner(this);
    }

    public boolean removeColumn(Column column) {
        column.setOwner(null);
        return this.columns.remove(column);
    }

    public void addPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKeys.add(primaryKey);
        primaryKey.setOwner(this);
    }

    public boolean removePrimaryKey(PrimaryKey primaryKey) {
        primaryKey.setOwner(null);
        return this.primaryKeys.remove(primaryKey);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
        foreignKey.setOwner(this);
    }

    public boolean removeForeignKey(ForeignKey foreignKey) {
        foreignKey.setOwner(null);
        return this.foreignKeys.remove(foreignKey);
    }

    public void toCreateSQL(PrintWriter out) {
        out.println("CREATE TABLE " + this.name + " (");
        Iterator<Serializable> i = this.columns.iterator();
        while (i.hasNext()) {
            Column c = i.next();
            out.print("  " + c.getName() + " " + c.getTypeName());
            if (c.getNullable() == 0) {
                out.print(" NOT NULL");
            }
            if (!i.hasNext()) continue;
            out.println(',');
        }
        if (!this.primaryKeys.isEmpty()) {
            out.println(',');
            i = this.primaryKeys.iterator();
            PrimaryKey pk = (PrimaryKey)i.next();
            out.print("  ");
            if (pk.getName() != null) {
                out.print("CONSTRAINT " + pk.getName() + " ");
            }
            out.print("PRIMARY KEY (" + pk.getColumnName());
            while (i.hasNext()) {
                pk = (PrimaryKey)i.next();
                out.print(", " + pk.getColumnName());
            }
            out.print(")");
        }
        if (!this.foreignKeys.isEmpty()) {
            out.println(',');
            i = this.foreignKeys.iterator();
            while (i.hasNext()) {
                ForeignKey fk = (ForeignKey)i.next();
                out.print("  ");
                if (fk.getName() != null) {
                    out.print("CONSTRAINT " + fk.getName() + " ");
                }
                out.print("FOREIGN KEY (" + fk.getColumnName() + ") REFERENCES " + fk.getPkTableName());
                if (fk.getPkColumnName() != null) {
                    out.print(" (" + fk.getPkColumnName() + ")");
                }
                if (!i.hasNext()) continue;
                out.println(',');
            }
        }
        out.println();
        out.print(")");
    }

    public void toDropSQL(PrintWriter out) {
        out.print("DROP TABLE " + this.name + " CASCADE CONSTRAINTS");
    }
}

