/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.util.Arrays;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.util.XMLSerializable;

public class CopyAttributeAction
extends CopyAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Copy Attribute";
    private static final String ACTION_NAME_MULTIPLE = "Copy Attributes";

    public static String getActionName() {
        return ACTION_NAME;
    }

    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public CopyAttributeAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        boolean isEnable = path.getObject() instanceof Attribute;
        if (!isEnable) {
            isEnable = path.getObject() instanceof EmbeddableAttribute;
        }
        return isEnable;
    }

    public Object copy(ProjectController mediator) {
        XMLSerializable[] attrs = this.getProjectController().getCurrentObjAttributes();
        if (attrs == null || attrs.length == 0) {
            attrs = this.getProjectController().getCurrentDbAttributes();
        }
        if (attrs == null || attrs.length == 0) {
            attrs = this.getProjectController().getCurrentEmbAttrs();
        }
        if (attrs != null && attrs.length > 0) {
            return Arrays.asList(attrs);
        }
        return null;
    }
}

