/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.ValueForNullProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueForNullProvider
implements ValueForNullProvider {
    private Map<String, ParameterBinding> values = new HashMap<String, ParameterBinding>();

    public void set(DbEntity entity, DbAttribute column, Object value, int type) {
        this.values.put(this.createKey(entity, column), new ParameterBinding(value, type, column.getAttributePrecision()));
    }

    protected ParameterBinding get(DbEntity entity, DbAttribute column) {
        return this.values.get(this.createKey(entity, column));
    }

    @Override
    public List<String> createSql(DbEntity entity, DbAttribute column) {
        ParameterBinding value = this.get(entity, column);
        if (value == null) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(entity.getFullyQualifiedName());
        sql.append(" SET ");
        sql.append(column.getName());
        sql.append("='");
        sql.append(value.getValue());
        sql.append("' WHERE ");
        sql.append(column.getName());
        sql.append(" IS NULL");
        return Collections.singletonList(sql.toString());
    }

    @Override
    public boolean hasValueFor(DbEntity entity, DbAttribute column) {
        return this.values.containsKey(this.createKey(entity, column));
    }

    private String createKey(DbEntity entity, DbAttribute attribute) {
        return (entity.getFullyQualifiedName() + "." + attribute.getName()).toUpperCase();
    }
}

