/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.TraversalHelper;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.Util;

public class SelectQueryValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath treeNodePath, Validator validator) {
        SelectQuery query = (SelectQuery)treeNodePath.getObject();
        this.validateName(query, treeNodePath, validator);
        Entity root = this.validateRoot(query, treeNodePath, validator);
        if (root != null) {
            this.validateQualifier(root, query.getQualifier(), treeNodePath, validator);
            for (Ordering ordering : query.getOrderings()) {
                this.validateOrdering(root, ordering, treeNodePath, validator);
            }
            if (query.getPrefetchTree() != null) {
                for (PrefetchTreeNode prefetchTreeNode : query.getPrefetchTree().nonPhantomNodes()) {
                    this.validatePrefetch(root, prefetchTreeNode.getPath(), treeNodePath, validator);
                }
            }
        }
    }

    protected Entity validateRoot(SelectQuery query, ProjectPath path, Validator validator) {
        QueryEngine parent;
        DataMap map = path.firstInstanceOf(DataMap.class);
        if (query.getRoot() == null && map != null) {
            validator.registerWarning("Query has no root", path);
            return null;
        }
        if (query.getRoot() == map) {
            return null;
        }
        if (map == null) {
            return query.getRoot() instanceof Entity ? (Entity)query.getRoot() : null;
        }
        if (query.getRoot() instanceof Entity) {
            return (Entity)query.getRoot();
        }
        if (query.getRoot() instanceof Class) {
            return null;
        }
        if (query.getRoot() instanceof String && (parent = path.firstInstanceOf(QueryEngine.class)) != null) {
            return parent.getEntityResolver().getObjEntity((String)query.getRoot());
        }
        return null;
    }

    protected void validateName(Query query, ProjectPath path, Validator validator) {
        String name = query.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed SelectQuery.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        for (Query otherQuery : map.getQueries()) {
            if (otherQuery == query || !name.equals(otherQuery.getName())) continue;
            validator.registerError("Duplicate Query name: " + name + ".", path);
            break;
        }
    }

    protected void validateQualifier(Entity entity, Expression qualifier, ProjectPath path, Validator validator) {
        try {
            this.testExpression(entity, qualifier);
        }
        catch (ExpressionException e) {
            validator.registerWarning(this.buildValidationMessage(e, "Invalid path in qualifier"), path);
        }
    }

    protected void validateOrdering(Entity entity, Ordering ordering, ProjectPath path, Validator validator) {
        if (ordering == null) {
            return;
        }
        try {
            this.testExpression(entity, ordering.getSortSpec());
        }
        catch (ExpressionException e) {
            validator.registerWarning(this.buildValidationMessage(e, "Invalid ordering"), path);
        }
    }

    protected void validatePrefetch(Entity entity, String prefetch, ProjectPath path, Validator validator) {
        if (prefetch == null) {
            return;
        }
        try {
            this.testExpression(entity, Expression.fromString(prefetch));
        }
        catch (ExpressionException e) {
            validator.registerWarning(this.buildValidationMessage(e, "Invalid prefetch"), path);
        }
    }

    private void testExpression(Entity rootEntity, Expression exp) throws ExpressionException {
        if (exp != null) {
            exp.traverse(new EntityExpressionValidator(rootEntity));
        }
    }

    private String buildValidationMessage(ExpressionException e, String prefix) {
        StringBuilder buffer = new StringBuilder(prefix);
        if (e.getExpressionString() != null) {
            buffer.append(": '").append(e.getExpressionString()).append("'");
        }
        buffer.append(".");
        return buffer.toString();
    }

    final class EntityExpressionValidator
    extends TraversalHelper {
        Entity rootEntity;

        EntityExpressionValidator(Entity rootEntity) {
            this.rootEntity = rootEntity;
        }

        public void startNode(Expression node, Expression parentNode) {
            if (node.getType() == 26 || node.getType() == 27) {
                node.evaluate(this.rootEntity);
            }
        }
    }
}

