/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingDelegate;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.util.Util;

public abstract class DataSourceEditor
extends CayenneController {
    protected ObjectBinding[] fieldAdapters;
    protected DataNode node;
    protected BindingDelegate nodeChangeProcessor;

    public DataSourceEditor(ProjectController controller, BindingDelegate nodeChangeProcessor) {
        super(controller);
        this.nodeChangeProcessor = nodeChangeProcessor;
        this.initBindings();
    }

    public DataNode getNode() {
        return this.node;
    }

    public void setNode(DataNode node) {
        if (!Util.nullSafeEquals((Object)this.node, (Object)node)) {
            this.node = node;
            for (ObjectBinding fieldAdapter : this.fieldAdapters) {
                fieldAdapter.updateView();
            }
        }
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.setDelegate(this.nodeChangeProcessor);
        this.prepareBindings(builder);
    }

    protected abstract void prepareBindings(BindingBuilder var1);

    protected void refreshView() {
        for (ObjectBinding fieldAdapter : this.fieldAdapters) {
            fieldAdapter.updateView();
        }
    }
}

