/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferences;
import org.apache.cayenne.modeler.dialog.pref.MavenDependencyDialogView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDependencyDialog
extends CayenneController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenDependencyDialog.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final ClasspathPreferences preferencesController;
    private final MavenDependencyDialogView view;
    private volatile boolean closing;

    public MavenDependencyDialog(ClasspathPreferences preferencesController) {
        this.preferencesController = preferencesController;
        Window parentView = preferencesController.getView() instanceof Window ? (Window)preferencesController.getView() : SwingUtilities.getWindowAncestor(preferencesController.getView());
        this.view = parentView instanceof Dialog ? new MavenDependencyDialogView((Dialog)parentView) : new MavenDependencyDialogView((Frame)parentView);
        this.initBindings();
    }

    private void initBindings() {
        this.view.getDownloadButton().addActionListener(e -> this.loadArtifact());
        this.view.getCancelButton().addActionListener(e -> this.close());
    }

    private void loadArtifact() {
        String groupPath = this.view.getGroupId().getText().replace('.', '/').trim();
        String artifactIdText = this.view.getArtifactId().getText().trim();
        String versionText = this.view.getVersion().getText().trim();
        if ("".equals(groupPath)) {
            JOptionPane.showMessageDialog(this.view, "Empty group Id", "Warning", 2);
            return;
        }
        if ("".equals(artifactIdText)) {
            JOptionPane.showMessageDialog(this.view, "Empty artifact Id", "Warning", 2);
            return;
        }
        if ("".equals(versionText)) {
            JOptionPane.showMessageDialog(this.view, "Empty version", "Warning", 2);
            return;
        }
        String urlText = "https://repo1.maven.org/maven2/" + groupPath + "/" + artifactIdText + "/" + versionText + "/" + artifactIdText + "-" + versionText + ".jar";
        Application.getInstance().getFrameController().updateStatus("Loading " + urlText);
        String localPath = System.getProperty("user.home") + "/.cayenne/modeler/" + groupPath + "/" + artifactIdText + "-" + versionText + ".jar";
        File targetFile = new File(localPath);
        this.view.getDownloadButton().setEnabled(false);
        new Thread(() -> this.download(urlText, targetFile)).start();
    }

    private void close() {
        this.closing = true;
        this.view.close();
    }

    public void download(String srcUrl, File dstFile) {
        if (!dstFile.getParentFile().exists() && !dstFile.getParentFile().mkdirs()) {
            this.finalizeDownload(dstFile, "Unable to create file " + String.valueOf(dstFile), false, false);
            return;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new URL(srcUrl).openStream());
            FileOutputStream os = new FileOutputStream(dstFile);
            this.transferTo(is, os);
        }
        catch (FileNotFoundException fnf) {
            this.finalizeDownload(dstFile, "Url not found: " + srcUrl, false, false);
            return;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to download Maven dependency " + srcUrl, e);
            this.finalizeDownload(dstFile, "Unable to download file " + String.valueOf(dstFile), false, true);
            return;
        }
        this.finalizeDownload(dstFile, "Succesfully downloaded", true, true);
    }

    private void finalizeDownload(File dstFile, String status, boolean success, boolean shouldClose) {
        SwingUtilities.invokeLater(() -> {
            if (success) {
                this.preferencesController.addClasspathEntry(dstFile);
            } else {
                JOptionPane.showMessageDialog(this.view, status, "Error", 0);
            }
            this.view.getDownloadButton().setEnabled(true);
            Application.getInstance().getFrameController().updateStatus(status);
            if (shouldClose) {
                this.close();
            }
        });
    }

    private void transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        Objects.requireNonNull(in);
        Objects.requireNonNull(out);
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            if (!this.closing) continue;
            break;
        }
    }

    @Override
    public Component getView() {
        return this.view;
    }
}

