/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog;

import java.util.Collection;
import java.util.List;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.commitlog.CommitLogListener;
import org.apache.cayenne.commitlog.DeletedDiffProcessor;
import org.apache.cayenne.commitlog.DiffFilter;
import org.apache.cayenne.commitlog.DiffProcessor;
import org.apache.cayenne.commitlog.meta.CommitLogEntityFactory;
import org.apache.cayenne.commitlog.model.ChangeMap;
import org.apache.cayenne.commitlog.model.MutableChangeMap;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;

public class CommitLogFilter
implements DataChannelSyncFilter {
    private final CommitLogEntityFactory entityFactory;
    private final Collection<CommitLogListener> listeners;

    public CommitLogFilter(@Inject CommitLogEntityFactory entityFactory, @Inject List<CommitLogListener> listeners) {
        this.entityFactory = entityFactory;
        this.listeners = listeners;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff beforeDiff, int syncType, DataChannelSyncFilterChain filterChain) {
        if (syncType != 2 && syncType != 1) {
            return filterChain.onSync(originatingContext, beforeDiff, syncType);
        }
        if (this.listeners.isEmpty()) {
            return filterChain.onSync(originatingContext, beforeDiff, syncType);
        }
        MutableChangeMap changes = new MutableChangeMap();
        DataChannel channel = originatingContext.getChannel();
        this.beforeCommit(changes, channel, beforeDiff);
        GraphDiff afterDiff = filterChain.onSync(originatingContext, beforeDiff, syncType);
        this.afterCommit(changes, channel, beforeDiff, afterDiff);
        this.notifyListeners(originatingContext, changes);
        return afterDiff;
    }

    private void beforeCommit(MutableChangeMap changes, DataChannel channel, GraphDiff contextDiff) {
        DiffFilter handler = new DiffFilter(this.entityFactory, new DeletedDiffProcessor(changes, channel, this.entityFactory));
        contextDiff.apply((GraphChangeHandler)handler);
    }

    private void afterCommit(MutableChangeMap changes, DataChannel channel, GraphDiff contextDiff, GraphDiff dbDiff) {
        DiffFilter handler = new DiffFilter(this.entityFactory, new DiffProcessor(changes, channel.getEntityResolver()));
        contextDiff.apply((GraphChangeHandler)handler);
        dbDiff.apply((GraphChangeHandler)handler);
    }

    private void notifyListeners(ObjectContext originatingContext, ChangeMap changes) {
        for (CommitLogListener l : this.listeners) {
            l.onPostCommit(originatingContext, changes);
        }
    }
}

