/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.editor.BaseQueryMainTab;
import org.apache.cayenne.modeler.util.CellRenderers;

class RootSelectionHandler
implements FocusListener,
ActionListener {
    private String newName = null;
    private boolean needChangeName;
    private final BaseQueryMainTab queryTab;

    RootSelectionHandler(BaseQueryMainTab queryTab) {
        this.queryTab = queryTab;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Entity root;
        QueryDescriptor query = this.queryTab.getQuery();
        if (query != null && (root = (Entity)this.queryTab.getQueryRoot().getModel().getSelectedItem()) != null) {
            query.setRoot(root);
            if (this.needChangeName) {
                String newPrefix = root.getName() + "Query";
                this.newName = newPrefix;
                DataMap map = this.queryTab.getMediator().getCurrentDataMap();
                long postfix = 1L;
                while (map.getQueryDescriptor(this.newName) != null) {
                    this.newName = newPrefix + postfix++;
                }
                this.queryTab.getNameField().setText(this.newName);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.newName = null;
        QueryDescriptor query = this.queryTab.getQuery();
        this.needChangeName = query != null ? this.hasDefaultName(query) : false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.newName != null) {
            this.queryTab.setQueryName(this.newName);
        }
        this.newName = null;
        this.needChangeName = false;
    }

    boolean hasDefaultName(QueryDescriptor query) {
        String prefix = query.getRoot() == null ? "UntitledQuery" : CellRenderers.asString(query.getRoot()) + "Query";
        return this.queryTab.getNameField().getComponent().getText().startsWith(prefix);
    }
}

