package org.apache.cayenne.testdo.unsupported_distinct_types.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.exp.property.ListProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.unsupported_distinct_types.Customer;
import org.apache.cayenne.testdo.unsupported_distinct_types.Product;

/**
 * Class _Customer was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Customer extends PersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<Customer> SELF = PropertyFactory.createSelf(Customer.class);

    public static final NumericIdProperty<Integer> ID_PK_PROPERTY = PropertyFactory.createNumericId("ID", "Customer", Integer.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final StringProperty<String> LONGVARCHAR_COL = PropertyFactory.createString("longvarcharCol", String.class);
    public static final ListProperty<Product> ORDER = PropertyFactory.createList("order", Product.class);

    protected String longvarcharCol;

    protected Object order;

    public void setLongvarcharCol(String longvarcharCol) {
        beforePropertyWrite("longvarcharCol", this.longvarcharCol, longvarcharCol);
        this.longvarcharCol = longvarcharCol;
    }

    public String getLongvarcharCol() {
        beforePropertyRead("longvarcharCol");
        return this.longvarcharCol;
    }

    public void addToOrder(Product obj) {
        addToManyTarget("order", obj, true);
    }

    public void removeFromOrder(Product obj) {
        removeToManyTarget("order", obj, true);
    }

    @SuppressWarnings("unchecked")
    public List<Product> getOrder() {
        return (List<Product>)readProperty("order");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "longvarcharCol":
                return this.longvarcharCol;
            case "order":
                return this.order;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "longvarcharCol":
                this.longvarcharCol = (String)val;
                break;
            case "order":
                this.order = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.longvarcharCol);
        out.writeObject(this.order);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.longvarcharCol = (String)in.readObject();
        this.order = in.readObject();
    }

}
