package org.apache.cayenne.testdo.things.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.GenericPersistentObject;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.NumericIdProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.SelfProperty;
import org.apache.cayenne.testdo.things.Ball;
import org.apache.cayenne.testdo.things.Box;
import org.apache.cayenne.testdo.things.Thing;

/**
 * Class _Ball was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Ball extends GenericPersistentObject {

    private static final long serialVersionUID = 1L;

    public static final SelfProperty<Ball> SELF = PropertyFactory.createSelf(Ball.class);

    public static final NumericIdProperty<Long> ID_PK_PROPERTY = PropertyFactory.createNumericId("ID", "Ball", Long.class);
    public static final String ID_PK_COLUMN = "ID";

    public static final NumericProperty<Integer> THING_VOLUME = PropertyFactory.createNumeric("thingVolume", Integer.class);
    public static final NumericProperty<Integer> THING_WEIGHT = PropertyFactory.createNumeric("thingWeight", Integer.class);
    public static final EntityProperty<Box> BOX = PropertyFactory.createEntity("box", Box.class);
    public static final EntityProperty<Thing> THING = PropertyFactory.createEntity("thing", Thing.class);

    protected Integer thingVolume;
    protected Integer thingWeight;

    protected Object box;
    protected Object thing;

    public void setThingVolume(Integer thingVolume) {
        beforePropertyWrite("thingVolume", this.thingVolume, thingVolume);
        this.thingVolume = thingVolume;
    }

    public Integer getThingVolume() {
        beforePropertyRead("thingVolume");
        return this.thingVolume;
    }

    public void setThingWeight(Integer thingWeight) {
        beforePropertyWrite("thingWeight", this.thingWeight, thingWeight);
        this.thingWeight = thingWeight;
    }

    public Integer getThingWeight() {
        beforePropertyRead("thingWeight");
        return this.thingWeight;
    }

    public void setBox(Box box) {
        setToOneTarget("box", box, true);
    }

    public Box getBox() {
        return (Box)readProperty("box");
    }

    public void setThing(Thing thing) {
        setToOneTarget("thing", thing, true);
    }

    public Thing getThing() {
        return (Thing)readProperty("thing");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "thingVolume":
                return this.thingVolume;
            case "thingWeight":
                return this.thingWeight;
            case "box":
                return this.box;
            case "thing":
                return this.thing;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "thingVolume":
                this.thingVolume = (Integer)val;
                break;
            case "thingWeight":
                this.thingWeight = (Integer)val;
                break;
            case "box":
                this.box = val;
                break;
            case "thing":
                this.thing = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.thingVolume);
        out.writeObject(this.thingWeight);
        out.writeObject(this.box);
        out.writeObject(this.thing);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.thingVolume = (Integer)in.readObject();
        this.thingWeight = (Integer)in.readObject();
        this.box = in.readObject();
        this.thing = in.readObject();
    }

}
