/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQuery;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.HierarchicalObjectResolver;
import org.apache.cayenne.access.ListWithPrefetches;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.Util;

class DataDomainQueryAction
implements QueryRouter,
OperationObserver {
    static final boolean DONE = true;
    DataContext context;
    DataDomain domain;
    DataRowStore cache;
    Query query;
    QueryMetadata metadata;
    QueryResponse response;
    GenericResponse fullResponse;
    Map<String, List<?>> prefetchResultsByPath;
    Map<QueryEngine, Collection<Query>> queriesByNode;
    Map<Query, Query> queriesByExecutedQueries;
    boolean noObjectConversion;

    DataDomainQueryAction(ObjectContext context, DataDomain domain, Query query) {
        if (context != null && !(context instanceof DataContext)) {
            throw new IllegalArgumentException("DataDomain can only work with DataContext. Unsupported context type: " + context);
        }
        this.domain = domain;
        this.query = query;
        this.metadata = query.getMetaData(domain.getEntityResolver());
        this.context = (DataContext)context;
        if (context != null) {
            this.cache = this.context.getObjectStore().getDataRowCache();
        }
        if (this.cache == null) {
            this.cache = domain.getSharedSnapshotCache();
        }
    }

    QueryResponse execute() {
        if (!(this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptRefreshQuery() || this.interceptSharedCache() || this.interceptDataDomainQuery())) {
            this.runQueryInTransaction();
        }
        if (!this.noObjectConversion) {
            this.interceptObjectConversion();
        }
        return this.response;
    }

    private boolean interceptDataDomainQuery() {
        if (this.query instanceof DataDomainQuery) {
            this.response = new ListResponse(this.domain);
            return true;
        }
        return false;
    }

    private boolean interceptOIDQuery() {
        if (this.query instanceof ObjectIdQuery) {
            ObjectIdQuery oidQuery = (ObjectIdQuery)this.query;
            ObjectId oid = oidQuery.getObjectId();
            if (oid.isTemporary() && !oid.isReplacementIdAttached()) {
                this.response = new ListResponse();
                return true;
            }
            DataRow row = null;
            if (this.cache != null && !oidQuery.isFetchMandatory()) {
                row = this.polymorphicRowFromCache(oid);
            }
            if (row == null) {
                if (oidQuery.isFetchAllowed()) {
                    this.runQueryInTransaction();
                } else {
                    this.response = new ListResponse();
                }
            } else {
                this.response = new ListResponse(row);
            }
            return true;
        }
        return false;
    }

    private DataRow polymorphicRowFromCache(ObjectId superOid) {
        DataRow row = this.cache.getCachedSnapshot(superOid);
        if (row != null) {
            return row;
        }
        EntityInheritanceTree inheritanceTree = this.domain.getEntityResolver().getInheritanceTree(superOid.getEntityName());
        if (!inheritanceTree.getChildren().isEmpty()) {
            row = this.polymorphicRowFromCache(inheritanceTree, superOid.getIdSnapshot());
        }
        return row;
    }

    private DataRow polymorphicRowFromCache(EntityInheritanceTree superNode, Map<String, ?> idSnapshot) {
        for (EntityInheritanceTree child : superNode.getChildren()) {
            ObjectId id = new ObjectId(child.getEntity().getName(), idSnapshot);
            DataRow row = this.cache.getCachedSnapshot(id);
            if (row != null) {
                return row;
            }
            row = this.polymorphicRowFromCache(child, idSnapshot);
            if (row == null) continue;
            return row;
        }
        return null;
    }

    private boolean interceptRelationshipQuery() {
        if (this.query instanceof RelationshipQuery) {
            RelationshipQuery relationshipQuery = (RelationshipQuery)this.query;
            if (relationshipQuery.isRefreshing()) {
                return false;
            }
            ObjRelationship relationship = relationshipQuery.getRelationship(this.domain.getEntityResolver());
            if (relationship.isSourceIndependentFromTargetChange()) {
                return false;
            }
            DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
            DbEntity targetEntity = dbRelationship.getTargetEntity();
            if (dbRelationship.getJoins().size() < targetEntity.getPrimaryKeys().size()) {
                return false;
            }
            if (this.cache == null) {
                return false;
            }
            DataRow sourceRow = this.cache.getCachedSnapshot(relationshipQuery.getObjectId());
            if (sourceRow == null) {
                return false;
            }
            ObjectId targetId = sourceRow.createTargetObjectId(relationship.getTargetEntityName(), dbRelationship);
            if (targetId == null) {
                this.response = new GenericResponse(Collections.EMPTY_LIST);
                return true;
            }
            DataRow targetRow = this.polymorphicRowFromCache(targetId);
            if (targetRow != null) {
                this.response = new GenericResponse(Collections.singletonList(targetRow));
                return true;
            }
            if (this.context != null && relationship.isSourceDefiningTargetPrecenseAndType(this.domain.getEntityResolver())) {
                this.noObjectConversion = true;
                Persistent object = this.context.findOrCreateObject(targetId);
                this.response = new GenericResponse(Collections.singletonList(object));
                return true;
            }
        }
        return false;
    }

    private boolean interceptRefreshQuery() {
        if (this.query instanceof RefreshQuery) {
            RefreshQuery refreshQuery = (RefreshQuery)this.query;
            if (refreshQuery.isRefreshAll()) {
                if (this.domain.getSharedSnapshotCache() != null) {
                    this.domain.getSharedSnapshotCache().clear();
                } else {
                    this.context.getObjectStore().getDataRowCache().clear();
                }
                this.context.getQueryCache().clear();
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
            Collection<?> objects = refreshQuery.getObjects();
            if (objects != null && !objects.isEmpty()) {
                ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
                for (Persistent object : objects) {
                    ids.add(object.getObjectId());
                }
                if (this.domain.getSharedSnapshotCache() != null) {
                    this.domain.getSharedSnapshotCache().processSnapshotChanges(this.context.getObjectStore(), Collections.emptyMap(), Collections.emptyList(), ids, Collections.emptyList());
                } else {
                    this.context.getObjectStore().getDataRowCache().processSnapshotChanges(this.context.getObjectStore(), Collections.emptyMap(), Collections.emptyList(), ids, Collections.emptyList());
                }
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
            if (refreshQuery.getQuery() != null) {
                Query cachedQuery = refreshQuery.getQuery();
                String cacheKey = cachedQuery.getMetaData(this.context.getEntityResolver()).getCacheKey();
                this.context.getQueryCache().remove(cacheKey);
                this.response = this.domain.onQuery(this.context, cachedQuery);
                return true;
            }
            if (refreshQuery.getGroupKeys() != null && refreshQuery.getGroupKeys().length > 0) {
                String[] groups;
                for (String group : groups = refreshQuery.getGroupKeys()) {
                    this.domain.getQueryCache().removeGroup(group);
                }
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
        }
        return false;
    }

    private boolean interceptSharedCache() {
        boolean cacheOrCacheRefresh;
        if (this.metadata.getCacheKey() == null) {
            return false;
        }
        boolean cache = QueryCacheStrategy.SHARED_CACHE == this.metadata.getCacheStrategy();
        boolean bl = cacheOrCacheRefresh = cache || QueryCacheStrategy.SHARED_CACHE_REFRESH == this.metadata.getCacheStrategy();
        if (!cacheOrCacheRefresh) {
            return false;
        }
        QueryCache queryCache = this.domain.getQueryCache();
        QueryCacheEntryFactory factory = this.getCacheObjectFactory();
        if (cache) {
            List cachedResults = queryCache.get(this.metadata, factory);
            if (this.response == null) {
                this.response = new ListResponse(cachedResults);
            }
            if (cachedResults instanceof ListWithPrefetches) {
                this.prefetchResultsByPath = ((ListWithPrefetches)cachedResults).getPrefetchResultsByPath();
            }
        } else {
            queryCache.put(this.metadata, factory.createObject());
        }
        return true;
    }

    private QueryCacheEntryFactory getCacheObjectFactory() {
        return () -> {
            this.runQueryInTransaction();
            ListWithPrefetches list = this.response.firstList();
            if (list != null) {
                list = Collections.unmodifiableList(list);
                if (this.prefetchResultsByPath != null) {
                    list = new ListWithPrefetches(list, this.prefetchResultsByPath);
                }
            }
            return list;
        };
    }

    void runQueryInTransaction() {
        this.domain.getTransactionManager().performInTransaction(() -> {
            this.runQuery();
            return null;
        });
    }

    private void runQuery() {
        this.fullResponse = new GenericResponse();
        this.response = this.fullResponse;
        this.queriesByNode = null;
        this.queriesByExecutedQueries = null;
        this.prefetchResultsByPath = this.metadata.getPrefetchTree() != null && !this.metadata.isFetchingDataRows() ? new HashMap() : null;
        this.query.route(this, this.domain.getEntityResolver(), null);
        if (this.queriesByNode != null) {
            for (Map.Entry<QueryEngine, Collection<Query>> entry : this.queriesByNode.entrySet()) {
                QueryEngine nextNode = entry.getKey();
                Collection<Query> nodeQueries = entry.getValue();
                nextNode.performQueries(nodeQueries, this);
            }
        }
    }

    private void interceptObjectConversion() {
        List mainRows;
        if (this.context != null && !this.metadata.isFetchingDataRows() && (mainRows = this.response.firstList()) != null && !mainRows.isEmpty()) {
            List<Object> rsMapping = this.metadata.getResultSetMapping();
            ObjectConversionStrategy converter = rsMapping == null ? new SingleObjectConversionStrategy() : (this.metadata.isSingleResultSetMapping() ? (rsMapping.get(0) instanceof EntityResultSegment ? new SingleObjectConversionStrategy() : new SingleScalarConversionStrategy()) : new MixedConversionStrategy());
            ((ObjectConversionStrategy)converter).convert(mainRows);
        }
    }

    @Override
    public void route(QueryEngine engine, Query query, Query substitutedQuery) {
        Collection<Query> queries = null;
        if (this.queriesByNode == null) {
            this.queriesByNode = new HashMap<QueryEngine, Collection<Query>>();
        } else {
            queries = this.queriesByNode.get(engine);
        }
        if (queries == null) {
            queries = new ArrayList<Query>(5);
            this.queriesByNode.put(engine, queries);
        }
        queries.add(query);
        if (substitutedQuery != null && substitutedQuery != query) {
            if (this.queriesByExecutedQueries == null) {
                this.queriesByExecutedQueries = new HashMap<Query, Query>();
            }
            this.queriesByExecutedQueries.put(query, substitutedQuery);
        }
    }

    @Override
    public QueryEngine engineForDataMap(DataMap map) {
        if (map == null) {
            throw new NullPointerException("Null DataMap, can't determine DataNode.");
        }
        DataNode node = this.domain.lookupDataNode(map);
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode exists for DataMap %s", map);
        }
        return node;
    }

    @Override
    public QueryEngine engineForName(String name) {
        DataNode node;
        if (name != null) {
            node = this.domain.getDataNode(name);
            if (node == null) {
                throw new CayenneRuntimeException("No DataNode exists for name %s", name);
            }
        } else {
            node = this.domain.getDefaultNode();
            if (node == null) {
                throw new CayenneRuntimeException("No default DataNode exists.", new Object[0]);
            }
        }
        return node;
    }

    @Override
    public void nextCount(Query query, int resultCount) {
        this.fullResponse.addUpdateCount(resultCount);
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
        this.fullResponse.addBatchUpdateCount(resultCount);
    }

    @Override
    public void nextRows(Query query, List<?> dataRows) {
        if (this.prefetchResultsByPath != null && query instanceof PrefetchSelectQuery) {
            PrefetchSelectQuery prefetchQuery = (PrefetchSelectQuery)query;
            this.prefetchResultsByPath.put(prefetchQuery.getPrefetchPath(), dataRows);
        } else {
            this.fullResponse.addResultList(dataRows);
        }
    }

    @Override
    public void nextRows(Query q, ResultIterator<?> it) {
        throw new CayenneRuntimeException("Invalid attempt to fetch a cursor.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextGeneratedRows(Query query, ResultIterator<?> keys, ObjectId idToUpdate) {
        if (keys != null) {
            try {
                this.nextRows(query, keys.allRows());
            }
            finally {
                keys.close();
            }
        }
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex), new Object[0]);
    }

    @Override
    public void nextGlobalException(Exception e) {
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(e), new Object[0]);
    }

    @Override
    public boolean isIteratedResult() {
        return false;
    }

    class SingleObjectConversionStrategy
    extends ObjectConversionStrategy<DataRow> {
        SingleObjectConversionStrategy() {
        }

        @Override
        void convert(List<DataRow> mainRows) {
            PrefetchTreeNode prefetchTree = DataDomainQueryAction.this.metadata.getPrefetchTree();
            List<Object> rsMapping = DataDomainQueryAction.this.metadata.getResultSetMapping();
            EntityResultSegment resultSegment = null;
            if (rsMapping != null && !rsMapping.isEmpty()) {
                resultSegment = (EntityResultSegment)rsMapping.get(0);
            }
            ClassDescriptor descriptor = resultSegment == null ? DataDomainQueryAction.this.metadata.getClassDescriptor() : resultSegment.getClassDescriptor();
            PrefetchProcessorNode node = this.toResultsTree(descriptor, prefetchTree, mainRows);
            ArrayList objects = node.getObjects();
            this.updateResponse(mainRows, objects != null ? objects : new ArrayList(1));
            LifecycleCallbackRegistry callbackRegistry = DataDomainQueryAction.this.context.getEntityResolver().getCallbackRegistry();
            if (!callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD)) {
                this.performPostLoadCallbacks(node, callbackRegistry);
            }
        }
    }

    class SingleScalarConversionStrategy
    extends ObjectConversionStrategy<Object> {
        SingleScalarConversionStrategy() {
        }

        @Override
        void convert(List<Object> mainRows) {
        }
    }

    class MixedConversionStrategy
    extends ObjectConversionStrategy<Object[]> {
        MixedConversionStrategy() {
        }

        protected PrefetchProcessorNode toResultsTree(ClassDescriptor descriptor, PrefetchTreeNode prefetchTree, List<Object[]> rows, int position) {
            ArrayList<DataRow> rowsColumn = new ArrayList<DataRow>(rows.size());
            for (Object[] row : rows) {
                rowsColumn.add((DataRow)row[position]);
            }
            if (prefetchTree != null) {
                PrefetchTreeNode prefetchTreeNode = null;
                for (PrefetchTreeNode prefetch : prefetchTree.getChildren()) {
                    if (!descriptor.getEntity().getName().equals(prefetch.getEntityName())) continue;
                    if (prefetchTreeNode == null) {
                        prefetchTreeNode = new PrefetchTreeNode();
                    }
                    PrefetchTreeNode addPath = prefetchTreeNode.addPath(prefetch.getPath());
                    addPath.setSemantics(prefetch.getSemantics());
                    addPath.setPhantom(false);
                }
                prefetchTree = prefetchTreeNode;
            }
            if (prefetchTree == null) {
                return new ObjectResolver(DataDomainQueryAction.this.context, descriptor, DataDomainQueryAction.this.metadata.isRefreshingObjects()).synchronizedRootResultNodeFromDataRows(rowsColumn);
            }
            HierarchicalObjectResolver resolver = new HierarchicalObjectResolver(DataDomainQueryAction.this.context, DataDomainQueryAction.this.metadata, descriptor, true);
            return resolver.synchronizedRootResultNodeFromDataRows(prefetchTree, rowsColumn, DataDomainQueryAction.this.prefetchResultsByPath);
        }

        @Override
        void convert(List<Object[]> mainRows) {
            LifecycleCallbackRegistry callbackRegistry;
            int rowsLen = mainRows.size();
            List<Object> rsMapping = DataDomainQueryAction.this.metadata.getResultSetMapping();
            int width = rsMapping.size();
            ArrayList<PrefetchProcessorNode> segmentNodes = new ArrayList<PrefetchProcessorNode>(width);
            for (int i = 0; i < width; ++i) {
                Object mapping = rsMapping.get(i);
                if (!(mapping instanceof EntityResultSegment)) continue;
                EntityResultSegment entitySegment = (EntityResultSegment)mapping;
                PrefetchProcessorNode nextResult = this.toResultsTree(entitySegment.getClassDescriptor(), DataDomainQueryAction.this.metadata.getPrefetchTree(), mainRows, i);
                segmentNodes.add(nextResult);
                List<Persistent> objects2 = nextResult.getObjects();
                for (int j = 0; j < rowsLen; ++j) {
                    Object[] row = mainRows.get(j);
                    row[i] = objects2.get(j);
                }
            }
            if (!DataDomainQueryAction.this.metadata.isSuppressingDistinct()) {
                HashSet seen = new HashSet(mainRows.size());
                mainRows.removeIf(objects -> !seen.add(Arrays.asList(objects)));
            }
            if (!(callbackRegistry = DataDomainQueryAction.this.context.getEntityResolver().getCallbackRegistry()).isEmpty(LifecycleEvent.POST_LOAD)) {
                for (PrefetchProcessorNode node : segmentNodes) {
                    this.performPostLoadCallbacks(node, callbackRegistry);
                }
            }
        }
    }

    abstract class ObjectConversionStrategy<T> {
        ObjectConversionStrategy() {
        }

        abstract void convert(List<T> var1);

        protected PrefetchProcessorNode toResultsTree(ClassDescriptor descriptor, PrefetchTreeNode prefetchTree, List<DataRow> normalizedRows) {
            if (prefetchTree == null) {
                return new ObjectResolver(DataDomainQueryAction.this.context, descriptor, DataDomainQueryAction.this.metadata.isRefreshingObjects()).synchronizedRootResultNodeFromDataRows(normalizedRows);
            }
            HierarchicalObjectResolver resolver = new HierarchicalObjectResolver(DataDomainQueryAction.this.context, DataDomainQueryAction.this.metadata);
            return resolver.synchronizedRootResultNodeFromDataRows(prefetchTree, normalizedRows, DataDomainQueryAction.this.prefetchResultsByPath);
        }

        protected void updateResponse(List sourceObjects, List targetObjects) {
            if (DataDomainQueryAction.this.response instanceof GenericResponse) {
                ((GenericResponse)DataDomainQueryAction.this.response).replaceResult(sourceObjects, targetObjects);
            } else if (DataDomainQueryAction.this.response instanceof ListResponse) {
                DataDomainQueryAction.this.response = new ListResponse(targetObjects);
            } else {
                throw new IllegalStateException("Unknown response object: " + DataDomainQueryAction.this.response);
            }
        }

        protected void performPostLoadCallbacks(PrefetchProcessorNode node, LifecycleCallbackRegistry callbackRegistry) {
            List<Persistent> objects;
            if (node.hasChildren()) {
                for (PrefetchTreeNode child : node.getChildren()) {
                    this.performPostLoadCallbacks((PrefetchProcessorNode)child, callbackRegistry);
                }
            }
            if ((objects = node.getObjects()) != null) {
                callbackRegistry.performCallbacks(LifecycleEvent.POST_LOAD, objects);
            }
        }
    }
}

