/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.ejbql.EJBQLJoinAppender;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;

class EJBQLIdentifierColumnsTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private Set<String> columns;

    EJBQLIdentifierColumnsTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        Map<String, String> xfields = null;
        if (this.context.isAppendingResultColumns()) {
            xfields = this.context.nextEntityResult().getFields();
        }
        final Map<String, String> fields = xfields;
        final String idVar = expression.getText();
        ClassDescriptor descriptor = this.context.getEntityDescriptor(idVar);
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                EJBQLJoinAppender joinAppender = null;
                String marker = null;
                EJBQLTableId lhsId = new EJBQLTableId(idVar);
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: %s", oa.getName());
                    }
                    if (pathPart instanceof DbRelationship) {
                        if (marker == null) {
                            marker = EJBQLJoinAppender.makeJoinTailMarker(idVar);
                            joinAppender = EJBQLIdentifierColumnsTranslator.this.context.getTranslatorFactory().getJoinAppender(EJBQLIdentifierColumnsTranslator.this.context);
                        }
                        DbRelationship dr = (DbRelationship)pathPart;
                        EJBQLTableId rhsId = new EJBQLTableId(lhsId, dr.getName());
                        joinAppender.appendOuterJoin(marker, lhsId, rhsId);
                        lhsId = rhsId;
                        continue;
                    }
                    if (!(pathPart instanceof DbAttribute)) continue;
                    EJBQLIdentifierColumnsTranslator.this.appendColumn(idVar, oa, (DbAttribute)pathPart, fields, oa.getType());
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                for (DbJoin join : dbRel.getJoins()) {
                    DbAttribute src = join.getSource();
                    EJBQLIdentifierColumnsTranslator.this.appendColumn(idVar, null, src, fields);
                }
            }
        };
        descriptor.visitAllProperties(visitor);
        DbEntity table = descriptor.getEntity().getDbEntity();
        for (DbAttribute pk : table.getPrimaryKeys()) {
            this.appendColumn(idVar, null, pk, fields);
        }
        for (ObjAttribute column : descriptor.getDiscriminatorColumns()) {
            this.appendColumn(idVar, column, column.getDbAttribute(), fields);
        }
        this.addPrefetchedColumnsIfAny(idVar);
        return false;
    }

    private void addPrefetchedColumnsIfAny(String visitedIdentifier) {
        PrefetchTreeNode prefetchTree = this.context.getCompiledExpression().getPrefetchTree();
        if (prefetchTree != null) {
            for (PrefetchTreeNode prefetch : prefetchTree.adjacentJointNodes()) {
                ClassDescriptor descriptor = this.context.getEntityDescriptor(prefetch.getEjbqlPathEntityId());
                if (!visitedIdentifier.equals(prefetch.getEjbqlPathEntityId())) continue;
                DbEntity table = descriptor.getRootDbEntities().iterator().next();
                ObjEntity objectEntity = descriptor.getEntity();
                prefetch.setEntityName(objectEntity.getName());
                Expression prefetchExp = ExpressionFactory.exp(prefetch.getPath(), new Object[0]);
                Expression dbPrefetch = objectEntity.translateToDbPath(prefetchExp);
                DbRelationship r = null;
                for (PathComponent<DbAttribute, DbRelationship> component : table.resolvePath(dbPrefetch, this.context.getMetadata().getPathSplitAliases())) {
                    r = component.getRelationship();
                }
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '%s' for entity: %s", prefetch, objectEntity.getName());
                }
                for (DbAttribute attribute : r.getTargetEntity().getAttributes()) {
                    this.appendColumn(prefetch.getEjbqlPathEntityId() + "." + prefetch.getPath(), attribute, "", prefetch.getPath() + "." + attribute.getName(), null);
                }
            }
        }
    }

    public void appendColumn(String identifier, ObjAttribute property, DbAttribute column, Map<String, String> fields) {
        this.appendColumn(identifier, property, column, fields, null);
    }

    public void appendColumn(String identifier, ObjAttribute property, DbAttribute column, Map<String, String> fields, String javaType) {
        String columnLabel = "";
        if (this.context.isAppendingResultColumns()) {
            columnLabel = fields.get(property != null ? property.getDbAttributePath() : column.getName());
        }
        this.appendColumn(identifier, column, columnLabel, columnLabel, javaType);
    }

    public void appendColumn(String identifier, DbAttribute column, String columnAlias, String dataRowKey, String javaType) {
        DbEntity table = column.getEntity();
        String alias = this.context.getTableAlias(identifier, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
        String columnName = alias + "." + this.context.getQuotingStrategy().quotedName(column);
        Set<String> columns = this.getColumns();
        if (columns.add(columnName)) {
            this.context.append(columns.size() > 1 ? ", " : " ");
            if (this.context.isAppendingResultColumns()) {
                this.context.append("#result('");
            }
            this.context.append(columnName);
            if (this.context.isAppendingResultColumns()) {
                if (javaType == null) {
                    javaType = TypesMapping.getJavaBySqlType(column.getType());
                }
                this.context.append("' '").append(javaType).append("' '").append(columnAlias).append("' '").append(dataRowKey).append("' " + column.getType()).append(")");
            }
        }
    }

    private Set<String> getColumns() {
        if (this.columns == null) {
            this.columns = new HashSet<String>();
        }
        return this.columns;
    }
}

