/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.util.Arrays;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.util.XMLSerializable;

public class CopyAttributeAction
extends CopyAction
implements MultipleObjectsAction {
    private static final String ACTION_NAME = "Copy Attribute";
    private static final String ACTION_NAME_MULTIPLE = "Copy Attributes";

    public static String getActionName() {
        return ACTION_NAME;
    }

    @Override
    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public CopyAttributeAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        boolean isEnable = object instanceof Attribute;
        if (!isEnable) {
            isEnable = object instanceof EmbeddableAttribute;
        }
        return isEnable;
    }

    @Override
    public Object copy(ProjectController mediator) {
        XMLSerializable[] attrs = this.getProjectController().getCurrentObjAttributes();
        if (attrs == null || attrs.length == 0) {
            attrs = this.getProjectController().getCurrentDbAttributes();
        }
        if (attrs == null || attrs.length == 0) {
            attrs = this.getProjectController().getCurrentEmbAttributes();
        }
        if (attrs != null && attrs.length > 0) {
            return Arrays.asList(attrs);
        }
        return null;
    }
}

