/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributePathBrowser;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class ObjAttributeInfoDialogView
extends JDialog {
    protected MultiColumnBrowser pathBrowser;
    protected JButton cancelButton;
    protected JButton saveButton;
    protected JButton selectPathButton;
    protected JTextField attributeName;
    protected JLabel currentPathLabel;
    protected JLabel sourceEntityLabel;
    protected JComboBox<String> typeComboBox;
    protected JPanel typeManagerPane;
    protected CayenneTable overrideAttributeTable;
    protected TableColumnPreferences tablePreferences;
    ProjectController mediator;
    static final Dimension BROWSER_CELL_DIM = new Dimension(130, 200);
    static final String EMBEDDABLE_PANEL = "EMBEDDABLE_PANEL";
    static final String FLATTENED_PANEL = "FLATTENED_PANEL";

    public ObjAttributeInfoDialogView(final ProjectController mediator) {
        this.mediator = mediator;
        this.cancelButton = new JButton("Cancel");
        this.saveButton = new JButton("Done");
        this.selectPathButton = new JButton("Select path");
        this.attributeName = new JTextField(25);
        this.currentPathLabel = new JLabel();
        this.sourceEntityLabel = new JLabel();
        this.typeComboBox = Application.getWidgetFactory().createComboBox(ModelerUtil.getRegisteredTypeNames(), false);
        AutoCompletion.enable(this.typeComboBox, false, true);
        this.typeComboBox.getRenderer();
        this.overrideAttributeTable = new CayenneTable();
        this.tablePreferences = new TableColumnPreferences(this.getClass(), "overrideAttributeTable");
        this.getRootPane().setDefaultButton(this.saveButton);
        this.saveButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.selectPathButton.setEnabled(false);
        this.setTitle("ObjAttribute Inspector");
        this.setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(50dlu;pref), 3dlu, 200dlu, 15dlu, right:max(30dlu;pref), 3dlu, 200dlu", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 6dlu, p, 6dlu, p, 3dlu, fill:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addSeparator("ObjAttribute Information", cc.xywh(1, 1, 7, 1));
        builder.addLabel("Entity:", cc.xy(1, 3));
        builder.add((Component)this.sourceEntityLabel, cc.xywh(3, 3, 1, 1));
        builder.addLabel("Attribute Name:", cc.xy(1, 5));
        builder.add((Component)this.attributeName, cc.xywh(3, 5, 1, 1));
        builder.addLabel("Current Db Path:", cc.xy(1, 7));
        builder.add((Component)this.currentPathLabel, cc.xywh(3, 7, 5, 1));
        builder.addLabel("Type:", cc.xy(1, 9));
        builder.add(this.typeComboBox, cc.xywh(3, 9, 1, 1));
        builder.addSeparator("Mapping to DbAttributes", cc.xywh(1, 11, 7, 1));
        this.typeManagerPane = new JPanel();
        this.typeManagerPane.setLayout(new CardLayout());
        final FormLayout fL = new FormLayout("493dlu ", "p, 3dlu, fill:min(128dlu;pref):grow");
        PanelBuilder builderPathPane = new PanelBuilder(fL);
        JPanel buttonsPane = new JPanel(new FlowLayout(3));
        buttonsPane.add(this.selectPathButton);
        builderPathPane.add((Component)buttonsPane, cc.xywh(1, 1, 1, 1));
        this.pathBrowser = new ObjAttributePathBrowser(this.selectPathButton, this.saveButton);
        this.pathBrowser.setPreferredColumnSize(BROWSER_CELL_DIM);
        this.pathBrowser.setDefaultRenderer();
        builderPathPane.add((Component)new JScrollPane(this.pathBrowser, 20, 30), cc.xywh(1, 3, 1, 1));
        final FormLayout fLEmb = new FormLayout("493dlu ", "fill:min(140dlu;pref):grow");
        PanelBuilder embeddablePane = new PanelBuilder(fLEmb);
        embeddablePane.add((Component)new JScrollPane(this.overrideAttributeTable, 20, 30), cc.xywh(1, 1, 1, 1));
        this.typeManagerPane.add((Component)builderPathPane.getPanel(), FLATTENED_PANEL);
        this.typeManagerPane.add((Component)embeddablePane.getPanel(), EMBEDDABLE_PANEL);
        builder.add((Component)this.typeManagerPane, cc.xywh(1, 13, 7, 1));
        this.add((Component)builder.getPanel(), "Center");
        this.addComponentListener(new ComponentListener(){
            int height;

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                int delta = e.getComponent().getHeight() - this.height;
                if (delta < 0) {
                    fL.setRowSpec(3, RowSpec.decode("fill:min(10dlu;pref):grow"));
                    fLEmb.setRowSpec(1, RowSpec.decode("fill:min(10dlu;pref):grow"));
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.height = e.getComponent().getHeight();
            }
        });
        JButton[] buttons = new JButton[]{this.cancelButton, this.saveButton};
        this.add((Component)PanelFactory.createButtonPanel(buttons), "South");
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] typeNames;
                boolean isType = false;
                for (String typeName : typeNames = ModelerUtil.getRegisteredTypeNames()) {
                    if (ObjAttributeInfoDialogView.this.typeComboBox.getSelectedItem() != null && !typeName.equals(ObjAttributeInfoDialogView.this.typeComboBox.getSelectedItem().toString())) continue;
                    isType = true;
                }
                if (isType || !mediator.getEmbeddableNamesInCurrentDataDomain().contains((String)ObjAttributeInfoDialogView.this.typeComboBox.getSelectedItem())) {
                    ((CardLayout)ObjAttributeInfoDialogView.this.typeManagerPane.getLayout()).show(ObjAttributeInfoDialogView.this.typeManagerPane, ObjAttributeInfoDialogView.FLATTENED_PANEL);
                } else {
                    ((CardLayout)ObjAttributeInfoDialogView.this.typeManagerPane.getLayout()).show(ObjAttributeInfoDialogView.this.typeManagerPane, ObjAttributeInfoDialogView.EMBEDDABLE_PANEL);
                    ObjAttributeInfoDialogView.this.getCurrentPathLabel().setText("");
                }
            }
        });
    }

    public CayenneTable getOverrideAttributeTable() {
        return this.overrideAttributeTable;
    }

    public TableColumnPreferences getTablePreferences() {
        return this.tablePreferences;
    }

    public JComboBox<String> getTypeComboBox() {
        return this.typeComboBox;
    }

    public MultiColumnBrowser getPathBrowser() {
        return this.pathBrowser;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getSaveButton() {
        return this.saveButton;
    }

    public JButton getSelectPathButton() {
        return this.selectPathButton;
    }

    public JTextField getAttributeName() {
        return this.attributeName;
    }

    public JLabel getCurrentPathLabel() {
        return this.currentPathLabel;
    }

    public JLabel getSourceEntityLabel() {
        return this.sourceEntityLabel;
    }
}

