/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.PatternMatchNode;

public class PostgresQualifierTranslator
extends TrimmingQualifierTranslator {
    public PostgresQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "RTRIM");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            this.detectObjectMatch(node);
            try {
                if (!this.parenthesisNeeded(node, parentNode)) return;
                this.out.append('(');
                return;
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
            }
        } else {
            super.startNode(node, parentNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2) {
            try {
                if (this.matchingObject) {
                    this.appendObjectMatch();
                }
                if (PatternMatchNode.class.isAssignableFrom(node.getClass())) {
                    this.appendLikeEscapeCharacter((PatternMatchNode)node);
                }
                if (!this.parenthesisNeeded(node, parentNode)) return;
                this.out.append(')');
                return;
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
            }
        } else {
            super.endNode(node, parentNode);
        }
    }

    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        try {
            switch (node.getType()) {
                case 12: {
                    this.finishedChildNodeAppendExpression(node, " ILIKE ");
                    break;
                }
                case 38: {
                    this.finishedChildNodeAppendExpression(node, " NOT ILIKE ");
                    break;
                }
                default: {
                    super.finishedChild(node, childIndex, hasMoreChildren);
                    break;
                }
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
        }
    }

    private void finishedChildNodeAppendExpression(Expression node, String operation) throws IOException {
        Appendable buf = this.matchingObject ? new StringBuilder() : this.out;
        buf.append(operation);
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(buf.toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }
}

