/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class SchemaMutationsSerializer
implements IVersionedSerializer<Collection<Mutation>> {
    public static final SchemaMutationsSerializer instance = new SchemaMutationsSerializer();

    @Override
    public void serialize(Collection<Mutation> schema, DataOutputPlus out, int version) throws IOException {
        out.writeInt(schema.size());
        for (Mutation mutation : schema) {
            Mutation.serializer.serialize(mutation, out, version);
        }
    }

    @Override
    public Collection<Mutation> deserialize(DataInputPlus in, int version) throws IOException {
        int count = in.readInt();
        ArrayList<Mutation> schema = new ArrayList<Mutation>(count);
        for (int i = 0; i < count; ++i) {
            schema.add(Mutation.serializer.deserialize(in, version));
        }
        return schema;
    }

    @Override
    public long serializedSize(Collection<Mutation> schema, int version) {
        int size = TypeSizes.sizeof(schema.size());
        for (Mutation mutation : schema) {
            size += mutation.serializedSize(version);
        }
        return size;
    }
}

