/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.Queries;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.rest.Binder;

public class BindBlockDeviceMappingToIndexedFormParams
implements Binder {
    private static final String deviceNamePattern = "BlockDeviceMapping.%d.DeviceName";
    private static final String deleteOnTerminationPattern = "BlockDeviceMapping.%d.Ebs.DeleteOnTermination";
    private static final String volumeIdPattern = "BlockDeviceMapping.%d.Ebs.VolumeId";

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"this binder is only valid for Map");
        Map blockDeviceMapping = (Map)input;
        Multimap original = (Multimap)Queries.queryParser().apply((Object)request.getPayload().getRawContent().toString());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll((Object)"Action", (Object[])new String[]{"ModifyInstanceAttribute"});
        int amazonOneBasedIndex = 1;
        for (Map.Entry ebsBlockDeviceName : blockDeviceMapping.entrySet()) {
            builder.put((Object)String.format(deviceNamePattern, amazonOneBasedIndex), (Object)((String)ebsBlockDeviceName.getKey()));
            builder.put((Object)String.format(deleteOnTerminationPattern, amazonOneBasedIndex), (Object)String.valueOf(((BlockDevice)ebsBlockDeviceName.getValue()).isDeleteOnTermination()));
            builder.put((Object)String.format(volumeIdPattern, amazonOneBasedIndex), (Object)((BlockDevice)ebsBlockDeviceName.getValue()).getVolumeId());
            ++amazonOneBasedIndex;
        }
        builder.putAll((Object)"InstanceId", (Iterable)original.get((Object)"InstanceId"));
        request.setPayload((Payload)Payloads.newUrlEncodedFormPayload((Multimap)builder.build()));
        return request;
    }
}

