/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonType;
import org.apache.brooklyn.core.resolve.jackson.JsonPassThroughDeserializer;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;

public class TransformJsonish
extends WorkflowTransformDefault {
    boolean json;
    boolean yaml;
    boolean bash;
    boolean parse;
    boolean string;
    boolean encode;

    public TransformJsonish(boolean json, boolean yaml, boolean bash) {
        this.json = json;
        this.yaml = yaml;
        this.bash = bash;
    }

    @Override
    protected void initCheckingDefinition() {
        MutableSet d = MutableSet.copyOf((Iterable)this.definition);
        this.json |= d.remove("json");
        this.yaml |= d.remove("yaml");
        if (this.yaml && this.json) {
            throw new IllegalArgumentException("Cannot specify both 'yaml' and 'json'");
        }
        this.bash |= d.remove("bash");
        if (this.yaml && this.bash) {
            throw new IllegalArgumentException("Cannot specify 'yaml' for 'bash' output; use JSON");
        }
        this.parse |= d.remove("parse");
        if (this.parse && this.bash) {
            throw new IllegalArgumentException("Cannot specify 'parse' with 'bash'");
        }
        this.encode |= d.remove("encode");
        if (this.parse && this.encode) {
            throw new IllegalArgumentException("Cannot specify both 'parse' and 'encode'");
        }
        this.string |= d.remove("string");
        if (this.parse && this.string) {
            throw new IllegalArgumentException("Cannot specify both 'parse' and 'string'");
        }
        if (!d.isEmpty()) {
            throw new IllegalArgumentException("Unsupported json/yaml arguments: " + d);
        }
    }

    public Object apply(Object v) {
        try {
            boolean readNeeded;
            boolean serializeNeeded;
            ObjectMapper mapper;
            if (this.yaml) {
                mapper = BeanWithTypeUtils.newYamlMapper(this.context.getManagementContext(), true, null, true);
            } else if (this.bash || this.json) {
                mapper = BeanWithTypeUtils.newMapper(this.context.getManagementContext(), true, null, true);
            } else {
                throw new IllegalArgumentException("Expected json/yaml/bash");
            }
            boolean stringSupplied = v instanceof String;
            boolean generated = false;
            if (v != null && !this.encode && this.yaml && stringSupplied) {
                v = Yamls.lastDocumentFunction().apply((Object)((String)v));
            }
            boolean bl = this.encode ? true : (this.parse || this.string || this.bash ? !stringSupplied : (serializeNeeded = !Jsonya.isJsonPrimitiveDeep((Object)v)));
            if (serializeNeeded) {
                v = mapper.writeValueAsString(v);
                generated = true;
            }
            boolean bl2 = this.encode ? false : (this.parse ? true : (this.string || this.bash ? false : (readNeeded = stringSupplied || generated)));
            if (readNeeded) {
                v = ((JsonPassThroughDeserializer.JsonObjectHolder)mapper.readValue((String)((String)v), BrooklynJacksonType.asTypeReference(TypeToken.of(JsonPassThroughDeserializer.JsonObjectHolder.class)))).value;
            }
            if (this.shouldTrim(v, generated)) {
                v = ((String)v).trim();
            }
            if (this.bash) {
                v = StringEscapes.BashStringEscapes.wrapBash((String)("" + v));
            }
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return v;
    }

    private boolean shouldTrim(Object resultCoerced, boolean generated) {
        if (generated && resultCoerced instanceof String) {
            String rst = ((String)resultCoerced).trim();
            if (rst.endsWith("\"") || rst.endsWith("'")) {
                return true;
            }
            if (this.yaml && (rst.endsWith("+") || rst.endsWith("|"))) {
                return false;
            }
            return !Strings.isMultiLine((String)rst);
        }
        return false;
    }
}

