/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class JobResult {
    private final boolean success;
    private final String displayText;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromJobResult(this);
    }

    @ConstructorProperties(value={"success", "displaytext"})
    protected JobResult(boolean success, @Nullable String displayText) {
        this.success = success;
        this.displayText = displayText;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getDisplayText() {
        return this.displayText;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.success, this.displayText});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobResult that = (JobResult)JobResult.class.cast(obj);
        return Objects.equal((Object)this.success, (Object)that.success) && Objects.equal((Object)this.displayText, (Object)that.displayText);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("success", this.success).add("displayText", (Object)this.displayText);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected boolean success;
        protected String displayText;

        protected abstract T self();

        public T success(boolean success) {
            this.success = success;
            return this.self();
        }

        public T displayText(String displayText) {
            this.displayText = displayText;
            return this.self();
        }

        public JobResult build() {
            return new JobResult(this.success, this.displayText);
        }

        public T fromJobResult(JobResult in) {
            return ((Builder)this.success(in.isSuccess())).displayText(in.getDisplayText());
        }
    }
}

