/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.brooklyn.rest.domain.SensorSummary;

@Path(value="/applications/{application}/entities/{entity}/sensors")
@Api(value="Entity Sensors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface SensorApi {
    @GET
    @ApiOperation(value="Fetch the sensor list for a specific application entity", response=SensorSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application or entity"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<SensorSummary> list(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2);

    @GET
    @Path(value="/current-state")
    @ApiOperation(value="Fetch sensor values in batch", notes="Returns a map of sensor name to value")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application or entity"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, Object> batchSensorRead(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Whether to format/annotate values with hints for for display", required=false) @QueryParam(value="useDisplayHints") @DefaultValue(value="true") Boolean var3, @ApiParam(value="Return raw sensor data instead of display values (deprecated, see useDisplayHints)", required=false) @Deprecated @QueryParam(value="raw") @DefaultValue(value="false") Boolean var4, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var5);

    @GET
    @Path(value="/{sensor}")
    @ApiOperation(value="Fetch sensor value (json)", response=Object.class)
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public Object get(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Whether to format/annotate values with hints for for display", required=false) @QueryParam(value="useDisplayHints") @DefaultValue(value="true") Boolean var4, @ApiParam(value="Return raw sensor data instead of display values (deprecated, see useDisplayHints)", required=false) @Deprecated @QueryParam(value="raw") @DefaultValue(value="false") Boolean var5, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var6);

    @GET
    @Path(value="/{sensor}")
    @ApiOperation(value="Fetch sensor value (text/plain)", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    @Produces(value={"text/plain;qs=0.9"})
    public String getPlain(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Whether to format/annotate values with hints for for display", required=false) @QueryParam(value="useDisplayHints") @DefaultValue(value="true") Boolean var4, @ApiParam(value="Return raw sensor data instead of display values (deprecated, see useDisplayHints)", required=false) @Deprecated @QueryParam(value="raw") @DefaultValue(value="false") Boolean var5, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var6);

    @POST
    @ApiOperation(value="Manually set multiple sensor values")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public void setFromMap(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Map of sensor names to values", required=true) Map var3);

    @POST
    @Path(value="/{sensor}")
    @ApiOperation(value="Manually set a sensor value")
    @ApiResponses(value={@ApiResponse(code=201, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public void set(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3, @ApiParam(value="Value to set") Object var4);

    @DELETE
    @Path(value="/{sensor}")
    @ApiOperation(value="Manually clear a sensor value")
    @ApiResponses(value={@ApiResponse(code=200, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application, entity, or sensor not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public void delete(@ApiParam(value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(value="Sensor name", required=true) @PathParam(value="sensor") String var3);
}

