/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Vault;
import org.jclouds.azurecompute.arm.domain.AutoValue_Vault_DeletedVault;
import org.jclouds.azurecompute.arm.domain.AutoValue_Vault_DeletedVaultProperties;
import org.jclouds.azurecompute.arm.domain.VaultProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Vault {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String type();

    public abstract String location();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract String name();

    public abstract VaultProperties properties();

    @SerializedNames(value={"id", "name", "type", "location", "properties", "tags"})
    public static Vault create(String id, String name, String type, String location, VaultProperties properties, Map<String, String> tags) {
        return Vault.builder().id(id).name(name).type(type).location(location).properties(properties).tags((Map<String, String>)(tags != null ? ImmutableMap.copyOf(tags) : null)).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Vault.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder type(String var1);

        public abstract Builder location(String var1);

        public abstract Builder properties(VaultProperties var1);

        public abstract Builder tags(Map<String, String> var1);

        abstract Map<String, String> tags();

        abstract Vault autoBuild();

        public Vault build() {
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null));
            return this.autoBuild();
        }
    }

    public static abstract class DeletedVaultProperties {
        @Nullable
        public abstract Date deletionDate();

        @Nullable
        public abstract String location();

        @Nullable
        public abstract Date scheduledPurgeDate();

        @Nullable
        public abstract Map<String, String> tags();

        @Nullable
        public abstract String vaultId();

        @SerializedNames(value={"deletionDate", "location", "scheduledPurgeDate", "tags", "vaultId"})
        public static DeletedVaultProperties create(Date deletionDate, String location, Date scheduledPurgeDate, Map<String, String> tags, String vaultId) {
            return new AutoValue_Vault_DeletedVaultProperties(deletionDate, location, scheduledPurgeDate, (Map<String, String>)(tags != null ? ImmutableMap.copyOf(tags) : null), vaultId);
        }
    }

    public static abstract class DeletedVault {
        @Nullable
        public abstract String id();

        @Nullable
        public abstract String name();

        @Nullable
        public abstract String type();

        @Nullable
        public abstract DeletedVaultProperties properties();

        @SerializedNames(value={"id", "name", "type", "properties"})
        public static DeletedVault create(String id, String name, String type, DeletedVaultProperties properties) {
            return new AutoValue_Vault_DeletedVault(id, name, type, properties);
        }
    }
}

