/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.aws.ec2.domain.Route;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class RouteSetHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<Route>> {
    private StringBuilder currentText = new StringBuilder();
    List<Route> results = Lists.newArrayList();
    Route.Builder builder;

    public List<Route> getResult() {
        try {
            List<Route> list = this.results;
            return list;
        }
        finally {
            this.results = Lists.newArrayList();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.currentText.setLength(0);
        if (qName.equalsIgnoreCase("item")) {
            this.builder = Route.builder();
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.builder == null) {
            return;
        }
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            this.results.add(this.builder.build());
            this.builder = null;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"destinationCidrBlock")) {
            this.builder.destinationCidrBlock(this.currentText.toString());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"gatewayId")) {
            this.builder.gatewayId(this.currentText.toString());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"state")) {
            this.builder.state(Route.RouteState.fromValue(this.currentText.toString()));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"origin")) {
            this.builder.origin(this.currentText.toString());
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

