/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;

public class Window
extends AbstractLoggingBean
implements Channel,
ChannelHolder {
    public static final Predicate<Window> SPACE_AVAILABLE_PREDICATE = input -> input.size > 0L;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AbstractChannel channelInstance;
    private final Object lock;
    private final String suffix;
    private long size;
    private long maxSize;
    private long packetSize;

    public Window(AbstractChannel channel, Object lock, boolean client, boolean local) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel provided");
        this.lock = lock != null ? lock : this;
        this.suffix = (client ? "client" : "server") + "/" + (local ? "local" : "remote");
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public void init(PropertyResolver resolver) {
        this.init(CoreModuleProperties.WINDOW_SIZE.getRequired(resolver), CoreModuleProperties.MAX_PACKET_SIZE.getRequired(resolver), resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long size, long packetSize, PropertyResolver resolver) {
        BufferUtils.validateUint32Value(size, "Illegal initial size: %d");
        BufferUtils.validateUint32Value(packetSize, "Illegal packet size: %d");
        ValidateUtils.checkTrue(packetSize > 0L, "Packet size must be positive: %d", packetSize);
        long limitPacketSize = CoreModuleProperties.LIMIT_PACKET_SIZE.getRequired(resolver);
        if (packetSize > limitPacketSize) {
            throw new IllegalArgumentException("Requested packet size (" + packetSize + ") exceeds max. allowed: " + limitPacketSize);
        }
        Object object = this.lock;
        synchronized (object) {
            this.maxSize = size;
            this.packetSize = packetSize;
            this.updateSize(size);
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.initialized.getAndSet(true) && debugEnabled) {
            this.log.debug("init({}) re-initializing", (Object)this);
        }
        if (debugEnabled) {
            this.log.debug("init({}) size={}, max={}, packet={}", new Object[]{this, this.getSize(), this.getMaxSize(), this.getPacketSize()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(long window) {
        long expandedSize;
        BufferUtils.validateUint32Value(window, "Invalid expansion window size: %d");
        this.checkInitialized("expand");
        Object object = this.lock;
        synchronized (object) {
            expandedSize = this.size + window;
            if (expandedSize > 0xFFFFFFFFL) {
                this.updateSize(0xFFFFFFFFL);
            } else {
                this.updateSize(expandedSize);
            }
        }
        if (expandedSize > Integer.MAX_VALUE) {
            this.log.warn("expand({}) window={} - truncated expanded size ({}) to {}", new Object[]{this, window, expandedSize, Integer.MAX_VALUE});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", new Object[]{this, window, expandedSize});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(long len) {
        long remainLen;
        BufferUtils.validateUint32Value(len, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            remainLen = this.size - len;
            if (remainLen >= 0L) {
                this.updateSize(remainLen);
            }
        }
        if (remainLen < 0L) {
            throw new IllegalStateException("consume(" + this + ") required length (" + len + ") above available: " + (remainLen + len));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Consume {} by {} down to {}", new Object[]{this, len, remainLen});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAndCheck(long len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.consume(len);
                this.check(this.maxSize);
            }
            catch (RuntimeException e) {
                throw new StreamCorruptedException("consumeAndCheck(" + this + ") failed (" + e.getClass().getSimpleName() + ") to consume " + len + " bytes: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(long maxFree) throws IOException {
        BufferUtils.validateUint32Value(maxFree, "Invalid check size: %d");
        this.checkInitialized("check");
        long adjustSize = -1L;
        AbstractChannel channel = this.getChannel();
        Object object = this.lock;
        synchronized (object) {
            long size = this.size;
            if (size < maxFree / 2L) {
                adjustSize = maxFree - size;
                channel.sendWindowAdjust(adjustSize);
                this.updateSize(maxFree);
            }
        }
        if (adjustSize >= 0L && this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", new Object[]{this, adjustSize, maxFree});
        }
    }

    public void waitAndConsume(long len, long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        this.waitAndConsume(len, Duration.ofMillis(maxWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(long len, Duration maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        BufferUtils.validateUint32Value(len, "Invalid wait consume length: %d", (Object)len);
        this.checkInitialized("waitAndConsume");
        boolean debugEnabled = this.log.isDebugEnabled();
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(input -> input.size >= len, maxWaitTime);
            if (debugEnabled) {
                this.log.debug("waitAndConsume({}) - requested={}, available={}", new Object[]{this, len, this.size});
            }
            this.consume(len);
        }
    }

    public long waitForSpace(long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        return this.waitForSpace(Duration.ofMillis(maxWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForSpace(Duration maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        long available;
        this.checkInitialized("waitForSpace");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(SPACE_AVAILABLE_PREDICATE, maxWaitTime);
            available = this.size;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("waitForSpace({}) available: {}", (Object)this, (Object)available);
        }
        return available;
    }

    protected void waitForCondition(Predicate<? super Window> predicate, Duration maxWaitTime) throws WindowClosedException, InterruptedException, SocketTimeoutException {
        Objects.requireNonNull(predicate, "No condition");
        ValidateUtils.checkTrue(GenericUtils.isPositive(maxWaitTime), "Non-positive max. wait time: %s", (Object)maxWaitTime.toString());
        Instant cur = Instant.now();
        Instant waitEnd = cur.plus(maxWaitTime);
        while (this.isOpen() && cur.compareTo(waitEnd) < 0) {
            if (predicate.test(this)) {
                return;
            }
            Duration rem = Duration.between(cur, waitEnd);
            this.lock.wait(rem.toMillis(), rem.getNano() % 1000000);
            cur = Instant.now();
        }
        if (!this.isOpen()) {
            throw new WindowClosedException(this.toString());
        }
        throw new SocketTimeoutException("waitForCondition(" + this + ") timeout exceeded: " + maxWaitTime);
    }

    protected void updateSize(long size) {
        BufferUtils.validateUint32Value(size, "Invalid updated size: %d", (Object)size);
        this.size = size;
        this.lock.notifyAll();
    }

    protected void checkInitialized(String location) {
        if (!this.initialized.get()) {
            throw new IllegalStateException(location + " - window not initialized: " + this);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true) && this.log.isDebugEnabled()) {
            this.log.debug("Closing {}", (Object)this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.suffix + "](" + this.getChannel() + ")";
    }
}

