/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.drivers.downloads;

import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.util.text.Strings;

public class FilenameProducers {
    public static String inferFilename(String target) {
        String result = target.substring(target.lastIndexOf("/") + 1);
        String string = result = result.contains("?") ? result.substring(0, result.indexOf("?")) : result;
        if (!result.contains(".")) {
            return null;
        }
        return result;
    }

    public static Function<DownloadResolverManager.DownloadRequirement, String> fromFilenameProperty() {
        return new Function<DownloadResolverManager.DownloadRequirement, String>(){

            public String apply(@Nullable DownloadResolverManager.DownloadRequirement req) {
                Object filename = req.getProperties().get("filename");
                return filename != null ? filename.toString() : null;
            }
        };
    }

    public static Function<DownloadResolverManager.DownloadRequirement, String> firstPrimaryTargetOf(final Function<DownloadResolverManager.DownloadRequirement, DownloadResolverManager.DownloadTargets> producer) {
        return new Function<DownloadResolverManager.DownloadRequirement, String>(){

            public String apply(@Nullable DownloadResolverManager.DownloadRequirement req) {
                DownloadResolverManager.DownloadTargets targets = (DownloadResolverManager.DownloadTargets)producer.apply((Object)req);
                List primaryTargets = targets.getPrimaryLocations();
                for (String primaryTarget : primaryTargets) {
                    String result = FilenameProducers.inferFilename(primaryTarget);
                    if (Strings.isBlank((CharSequence)result)) continue;
                    return result;
                }
                return null;
            }
        };
    }
}

