/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.http.utils.Queries;

public class LinkToListOptions
implements Function<URI, ListOptions> {
    public ListOptions apply(URI input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null");
        Multimap queryParams = (Multimap)Queries.queryParser().apply((Object)input.getQuery());
        String nextPage = LinkToListOptions.getFirstOrNull("page", (Multimap<String, String>)queryParams);
        String nextPerPage = LinkToListOptions.getFirstOrNull("per_page", (Multimap<String, String>)queryParams);
        ListOptions options = new ListOptions();
        if (nextPage != null) {
            options.page(Integer.parseInt(nextPage));
        }
        if (nextPerPage != null) {
            options.perPage(Integer.parseInt(nextPerPage));
        }
        return options;
    }

    public static String getFirstOrNull(String key, Multimap<String, String> params) {
        return params.containsKey((Object)key) ? Strings.emptyToNull((String)((String)Iterables.getFirst((Iterable)params.get((Object)key), null))) : null;
    }
}

