/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.sensor.BasicSensorEvent;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Joiner", description="Joins entity's sensors into another one, i.e. creates a comma separated string from a list")
public class Joiner<T>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Joiner.class);
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity that has the source sensors (defaults to the entity that the enricher is attached to)");
    public static final ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor", "The sensor (expected to be of type Map or Iterable) whose change triggers re-evaluation of the target value");
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor", "The sensor to be set on the associated entity with the value computed here");
    @SetFromFlag(value="separator")
    public static final ConfigKey<String> SEPARATOR = ConfigKeys.newStringConfigKey("enricher.joiner.separator", "Separator string to insert between each argument", ",");
    @SetFromFlag(value="keyValueSeparator")
    public static final ConfigKey<String> KEY_VALUE_SEPARATOR = ConfigKeys.newStringConfigKey("enricher.joiner.keyValueSeparator", "Separator string to insert between each key-value pair", "=");
    @SetFromFlag(value="joinMapEntries")
    public static final ConfigKey<Boolean> JOIN_MAP_ENTRIES = ConfigKeys.newBooleanConfigKey("enricher.joiner.joinMapEntries", "Whether to add map entries as key-value pairs or just use the value, defaulting to false", false);
    @SetFromFlag(value="quote")
    public static final ConfigKey<Boolean> QUOTE = ConfigKeys.newBooleanConfigKey("enricher.joiner.quote", "Whether to bash-escape each parameter and wrap in double-quotes, defaulting to true", true);
    @SetFromFlag(value="minimum")
    public static final ConfigKey<Integer> MINIMUM = ConfigKeys.newIntegerConfigKey("enricher.joiner.minimum", "Minimum number of elements to join; if fewer than this, sets null; default 0 (no minimum)");
    @SetFromFlag(value="maximum")
    public static final ConfigKey<Integer> MAXIMUM = ConfigKeys.newIntegerConfigKey("enricher.joiner.maximum", "Maximum number of elements to join; default null means all elements always taken");
    protected Entity producer;
    protected AttributeSensor<T> sourceSensor;
    protected Sensor<String> targetSensor;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensor = (AttributeSensor)this.getRequiredConfig(SOURCE_SENSOR);
        this.targetSensor = this.getRequiredConfig(TARGET_SENSOR);
        this.highlightTriggers((Sensor<?>)this.sourceSensor, (Object)this.producer);
        this.subscriptions().subscribe(this.producer, this.sourceSensor, this);
        Object value = this.producer.getAttribute(this.sourceSensor);
        if (value != null) {
            this.onEvent(new BasicSensorEvent<Object>((Sensor<Object>)this.sourceSensor, this.producer, value, -1L));
        }
    }

    public void onEvent(SensorEvent<T> event) {
        this.emit(this.targetSensor, this.compute(event));
    }

    protected Object compute(SensorEvent<T> event) {
        Collection v = event.getValue();
        String result = null;
        if (v != null) {
            if (v instanceof Map) {
                v = (Boolean)this.config().get(JOIN_MAP_ENTRIES) != false ? ((Map)((Object)v)).entrySet() : ((Map)((Object)v)).values();
            }
            if (!(v instanceof Iterable)) {
                LOG.warn("Enricher " + this + " received a non-iterable value " + v.getClass() + " " + v + "; refusing to join");
            } else {
                Integer minimum;
                MutableList c1 = MutableList.of();
                Integer maximum = (Integer)this.config().get(MAXIMUM);
                for (Object ci : (Iterable)v) {
                    if (maximum != null && maximum >= 0 && c1.size() >= maximum) break;
                    if (ci instanceof Map.Entry) {
                        String key = Strings.toString(((Map.Entry)ci).getKey());
                        Object value = ((Map.Entry)ci).getValue();
                        String keyValueSeparator = (String)this.config().get(KEY_VALUE_SEPARATOR);
                        if (value == null) continue;
                        c1.append((Object)String.format("%s%s%s", key, keyValueSeparator, Strings.toString(value)));
                        continue;
                    }
                    c1.appendIfNotNull((Object)Strings.toString(ci));
                }
                if ((minimum = (Integer)this.config().get(MINIMUM)) == null || c1.size() >= minimum) {
                    if (((Boolean)this.config().get(QUOTE)).booleanValue()) {
                        MutableList c2 = MutableList.of();
                        for (Object ci : c1) {
                            c2.add((Object)StringEscapes.BashStringEscapes.wrapBash((String)((String)ci)));
                        }
                        c1 = c2;
                    }
                    result = Strings.join((Iterable)c1, (String)((String)this.config().get(SEPARATOR)));
                }
            }
        }
        LOG.trace("Enricher " + this + " computed " + result + " from " + event);
        return result;
    }
}

