/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode.effector;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.drivers.DriverDependentEntity;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityTasks;
import org.apache.brooklyn.entity.brooklynnode.BrooklynCluster;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNodeDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynNodeUpgradeEffectorBody
extends EffectorBody<Void> {
    private static final Logger log = LoggerFactory.getLogger(BrooklynNodeUpgradeEffectorBody.class);
    public static final ConfigKey<String> DOWNLOAD_URL = BrooklynNode.DOWNLOAD_URL.getConfigKey();
    public static final ConfigKey<Boolean> DO_DRY_RUN_FIRST = ConfigKeys.newBooleanConfigKey((String)"doDryRunFirst", (String)"Test rebinding with a temporary instance before stopping the entity for upgrade.", (Boolean)true);
    public static final ConfigKey<Map<String, Object>> EXTRA_CONFIG = MapConfigKey.builder((TypeToken)new TypeToken<Map<String, Object>>(){}).name("extraConfig").description("Additional new config to set on the BrooklynNode as part of upgrading").build();
    public static final Effector<Void> UPGRADE = Effectors.effector(Void.class, (String)"upgrade").description("Changes the Brooklyn build used to run this node, by spawning a dry-run node then copying the installed files across. This node must be running for persistence for in-place upgrading to work.").parameter(BrooklynNode.SUGGESTED_VERSION).parameter(DOWNLOAD_URL).parameter(DO_DRY_RUN_FIRST).parameter(EXTRA_CONFIG).impl((EffectorBody)new BrooklynNodeUpgradeEffectorBody()).build();

    public Void call(ConfigBag parametersO) {
        ConfigBag parameters;
        if (!BrooklynNodeUpgradeEffectorBody.isPersistenceModeEnabled((Entity)this.entity())) {
            DynamicTasks.queue((TaskAdaptable)Tasks.warning((String)"Check persistence", (Throwable)new IllegalStateException("Persistence does not appear to be enabled at this cluster. In-place node upgrade will not succeed unless a custom launch script enables it.")));
        }
        if ((parameters = ConfigBag.newInstanceCopying((ConfigBag)parametersO)).containsKey(EXTRA_CONFIG)) {
            Map extra = (Map)parameters.get(EXTRA_CONFIG);
            parameters.remove(EXTRA_CONFIG);
            parameters.putAll(extra);
        }
        log.debug((Object)((Object)this) + " upgrading, using " + parameters);
        boolean doDryRunFirst = (Boolean)parameters.get(DO_DRY_RUN_FIRST);
        final String bkName = doDryRunFirst ? this.dryRunUpdate(parameters) : "direct-" + Identifiers.makeRandomId((int)4);
        DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("shutdown node").add(Effectors.invocation((Entity)this.entity(), BrooklynNode.STOP_NODE_BUT_LEAVE_APPS, (Map)ImmutableMap.of(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE, (Object)((Object)SoftwareProcess.StopSoftwareParameters.StopMode.NEVER)))).build());
        DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("backup old version").body(new Runnable(){

            @Override
            public void run() {
                String runDir = (String)BrooklynNodeUpgradeEffectorBody.this.entity().getAttribute(SoftwareProcess.RUN_DIR);
                String bkDir = Urls.mergePaths((String[])new String[]{runDir, "..", Urls.getBasename((String)runDir) + "-backups", bkName});
                log.debug(this + " storing backup of previous version in " + bkDir);
                DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + runDir, "mkdir -p " + bkDir, "mv * " + bkDir}).summary("move files"));
            }
        }).build());
        DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("reconfigure").body(new Runnable(){

            @Override
            public void run() {
                DynamicTasks.waitForLast();
                BrooklynNodeUpgradeEffectorBody.this.entity().sensors().set(SoftwareProcess.INSTALL_DIR, (Object)null);
                BrooklynNodeUpgradeEffectorBody.this.entity().config().set(SoftwareProcess.INSTALL_UNIQUE_LABEL, (Object)null);
                BrooklynNodeUpgradeEffectorBody.this.entity().config().putAll(parameters.getAllConfig());
                BrooklynNodeUpgradeEffectorBody.this.entity().sensors().set(BrooklynNode.DOWNLOAD_URL, BrooklynNodeUpgradeEffectorBody.this.entity().getConfig(DOWNLOAD_URL));
                ((BrooklynNodeDriver)((DriverDependentEntity)BrooklynNodeUpgradeEffectorBody.this.entity()).getDriver()).clearInstallDir();
            }
        }).build());
        DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)this.entity(), (Effector)BrooklynNode.START, (ConfigBag)ConfigBag.EMPTY));
        return null;
    }

    private String dryRunUpdate(ConfigBag parameters) {
        final Entity dryRunChild = this.entity().addChild((EntitySpec)((EntitySpec)this.createDryRunSpec().displayName("Upgraded Version Dry-Run Node")).configure(parameters.getAllConfig()));
        String launchParameters = (String)dryRunChild.getConfig(BrooklynNode.EXTRA_LAUNCH_PARAMETERS);
        launchParameters = Strings.isBlank((CharSequence)launchParameters) ? "" : launchParameters + " ";
        launchParameters = launchParameters + "--highAvailability " + HighAvailabilityMode.HOT_STANDBY;
        ((EntityInternal)dryRunChild).config().set(BrooklynNode.EXTRA_LAUNCH_PARAMETERS, (Object)launchParameters);
        String dryRunNodeUid = dryRunChild.getId();
        ((EntityInternal)dryRunChild).setDisplayName("Dry-Run Upgraded Brooklyn Node (" + dryRunNodeUid + ")");
        DynamicTasks.queue((TaskAdaptable)Effectors.invocation((Entity)dryRunChild, (Effector)BrooklynNode.START, (ConfigBag)ConfigBag.EMPTY));
        DynamicTasks.queue((TaskAdaptable)EntityTasks.requiringAttributeEventually((Entity)dryRunChild, BrooklynNode.MANAGEMENT_NODE_STATE, (Predicate)Predicates.equalTo((Object)ManagementNodeState.HOT_STANDBY), (Duration)Duration.FIVE_MINUTES));
        DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("shutdown transient node").add(Effectors.invocation((Entity)dryRunChild, BrooklynNode.STOP_NODE_BUT_LEAVE_APPS, (Map)ImmutableMap.of(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE, (Object)((Object)SoftwareProcess.StopSoftwareParameters.StopMode.NEVER)))).build());
        DynamicTasks.queue((TaskAdaptable)Tasks.builder().displayName("remove transient node").body(new Runnable(){

            @Override
            public void run() {
                Entities.unmanage((Entity)dryRunChild);
            }
        }).build());
        return dryRunChild.getId();
    }

    protected EntitySpec<? extends BrooklynNode> createDryRunSpec() {
        return EntitySpec.create(BrooklynNode.class);
    }

    @Beta
    static boolean isPersistenceModeEnabled(Entity entity) {
        String params = null;
        if (entity instanceof BrooklynCluster) {
            EntitySpec spec = (EntitySpec)entity.getConfig(BrooklynCluster.MEMBER_SPEC);
            params = Strings.toString(spec.getConfig().get(BrooklynNode.EXTRA_LAUNCH_PARAMETERS));
        }
        if (params == null) {
            params = (String)entity.getConfig(BrooklynNode.EXTRA_LAUNCH_PARAMETERS);
        }
        if (params == null) {
            return false;
        }
        return params.indexOf("persist") != 0;
    }
}

