/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.binders.BindToJsonPayload;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/flavor_extra_specs/api/v1.1", name="FlavorExtraSpecs", alias="os-flavor-extra-specs")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/flavors")
@Beta
public interface FlavorExtraSpecsApi {
    @Named(value="flavorExtraSpecs:getMetadata")
    @GET
    @Path(value="/{id}/os-extra_specs")
    @SelectJson(value={"extra_specs"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public Map<String, String> getMetadata(@PathParam(value="id") String var1);

    @Named(value="flavorExtraSpecs:updateMetadata")
    @POST
    @Path(value="/{id}/os-extra_specs")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public void updateMetadata(@PathParam(value="id") String var1, @PayloadParam(value="extra_specs") Map<String, String> var2);

    @Named(value="flavorExtraSpecs:getMetadataKey")
    @GET
    @Path(value="/{id}/os-extra_specs/{key}")
    @Unwrap
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public String getMetadataKey(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="flavorExtraSpecs:updateMetadataEntry")
    @PUT
    @Path(value="/{id}/os-extra_specs/{key}")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"{key}\":\"{value}\"%7D")
    public void updateMetadataEntry(@PathParam(value="id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PayloadParam(value="value") String var3);

    @Named(value="flavorExtraSpecs:deleteMetadataKey")
    @DELETE
    @Path(value="/{id}/os-extra_specs/{key}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteMetadataKey(@PathParam(value="id") String var1, @PathParam(value="key") String var2);
}

