/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.b2.B2Api;
import org.jclouds.b2.blobstore.config.B2BlobStoreContextModule;
import org.jclouds.b2.config.B2HttpApiModule;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public final class B2ApiMetadata
extends BaseHttpApiMetadata {
    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public B2ApiMetadata() {
        this(new Builder());
    }

    protected B2ApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.blobstore.metaprefix", "X-Bz-Info-");
        properties.setProperty("jclouds.session-interval", String.valueOf(TimeUnit.HOURS.toSeconds(1L)));
        properties.setProperty("jclouds.idempotent-methods", "DELETE,GET,HEAD,OPTIONS,POST,PUT");
        properties.setProperty("jclouds.retries-delay-start", String.valueOf(TimeUnit.SECONDS.toMillis(1L)));
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<B2Api, Builder> {
        protected Builder() {
            super(B2Api.class);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("b2")).name("Backblaze B2 API")).identityName("Account Id")).credentialName("Application Key")).documentation(URI.create("https://www.backblaze.com/b2/docs/"))).defaultEndpoint("https://api.backblazeb2.com/")).defaultProperties(B2ApiMetadata.defaultProperties())).view(Reflection2.typeToken(BlobStoreContext.class))).defaultModules((Set)ImmutableSet.of(B2HttpApiModule.class, B2BlobStoreContextModule.class));
        }

        public B2ApiMetadata build() {
            return new B2ApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            return this;
        }
    }
}

