/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.domain.Credentials;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfiguresCredentialStore
public class PropertiesCredentialStore
extends CredentialStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesCredentialStore.class);
    private final String PROPERTIES_FILE_PATH = System.getProperty("karaf.home") + File.separatorChar + "etc" + File.separatorChar + "org.jclouds.credentials.cfg";

    public PropertiesCredentialStore() {
        this.store = new PropertiesBacking();
    }

    protected void configure() {
    }

    private class PropertiesBacking
    implements Map<String, Credentials> {
        private final Map<String, Credentials> credentialsMap = new LinkedHashMap<String, Credentials>();
        private Properties properties = new Properties();

        private PropertiesBacking() {
            this.load();
            Enumeration<Object> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String stripedKey;
                String key = (String)keys.nextElement();
                if (key == null || !key.startsWith("node#") || this.credentialsMap.containsKey(stripedKey = key.substring(0, key.lastIndexOf("/")))) continue;
                String identityKey = stripedKey + "/identity";
                String credentialKey = stripedKey + "/credential";
                String identity = (String)this.properties.get(identityKey);
                String credential = (String)this.properties.get(credentialKey);
                Credentials credentials = new Credentials(identity, credential);
                this.credentialsMap.put(stripedKey, credentials);
            }
            this.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() {
            File f = new File(PropertiesCredentialStore.this.PROPERTIES_FILE_PATH);
            FileOutputStream fos = null;
            try {
                if (f.exists()) {
                    f.createNewFile();
                }
                fos = new FileOutputStream(f);
                this.properties.store(fos, "jclouds credentials");
            }
            catch (IOException e) {
                LOGGER.warn("Failed to store jclouds credentials to file.", (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() {
            File f = new File(PropertiesCredentialStore.this.PROPERTIES_FILE_PATH);
            FileInputStream fis = null;
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
                fis = new FileInputStream(f);
                this.properties.load(fis);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load jclouds credentials from file.", (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        @Override
        public int size() {
            return this.credentialsMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.credentialsMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.credentialsMap.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.credentialsMap.containsValue(o);
        }

        @Override
        public Credentials get(Object o) {
            return this.credentialsMap.get(o);
        }

        @Override
        public Credentials put(String s, Credentials credentials) {
            if (credentials != null) {
                String identityKey = s + "/identity";
                String credentialKey = s + "/credential";
                if (credentials.identity != null) {
                    this.properties.put(identityKey, credentials.identity);
                }
                if (credentials.credential != null) {
                    this.properties.put(credentialKey, credentials.credential);
                }
                this.save();
                return this.credentialsMap.put(s, credentials);
            }
            return credentials;
        }

        @Override
        public Credentials remove(Object o) {
            String identityKey = o + "/identity";
            this.properties.remove(identityKey);
            this.save();
            return this.credentialsMap.remove(o);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Credentials> map) {
            for (Map.Entry<? extends String, ? extends Credentials> entry : map.entrySet()) {
                String s = entry.getKey();
                Credentials credential = entry.getValue();
                this.put(s, credential);
            }
        }

        @Override
        public void clear() {
            this.properties.clear();
            this.save();
            this.credentialsMap.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.credentialsMap.keySet();
        }

        @Override
        public Collection<Credentials> values() {
            return this.credentialsMap.values();
        }

        @Override
        public Set<Map.Entry<String, Credentials>> entrySet() {
            return this.credentialsMap.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.credentialsMap.equals(o);
        }

        @Override
        public int hashCode() {
            return this.credentialsMap.hashCode();
        }
    }
}

