/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.jshell;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openjdk.jdi.BooleanValue;
import org.openjdk.jdi.ClassNotLoadedException;
import org.openjdk.jdi.IncompatibleThreadStateException;
import org.openjdk.jdi.InvalidTypeException;
import org.openjdk.jdi.ObjectReference;
import org.openjdk.jdi.ReferenceType;
import org.openjdk.jdi.StackFrame;
import org.openjdk.jdi.ThreadReference;
import org.openjdk.jdi.Value;
import org.openjdk.jdi.VirtualMachine;
import org.openjdk.tools.jshell.ClassTracker;
import org.openjdk.tools.jshell.DeclarationSnippet;
import org.openjdk.tools.jshell.EvalException;
import org.openjdk.tools.jshell.JDIConnection;
import org.openjdk.tools.jshell.JDIEnv;
import org.openjdk.tools.jshell.JDIEventHandler;
import org.openjdk.tools.jshell.JShell;
import org.openjdk.tools.jshell.Snippet;
import org.openjdk.tools.jshell.SnippetMaps;
import org.openjdk.tools.jshell.UnresolvedReferenceException;

class ExecutionControl {
    private final JDIEnv env;
    private final SnippetMaps maps;
    private JDIEventHandler handler;
    private Socket socket;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private final JShell proc;
    private final Object STOP_LOCK = new Object();
    private boolean userCodeRunning = false;

    ExecutionControl(JDIEnv env, SnippetMaps maps, JShell proc) {
        this.env = env;
        this.maps = maps;
        this.proc = proc;
    }

    void launch() throws IOException {
        try (ServerSocket listener = new ServerSocket(0);){
            listener.setSoTimeout(60000);
            int port = listener.getLocalPort();
            this.jdiGo(port);
            this.socket = listener.accept();
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            PipeInputStream commandIn = new PipeInputStream();
            new DemultiplexInput(this.socket.getInputStream(), commandIn, this.proc.out, this.proc.err).start();
            this.in = new ObjectInputStream(commandIn);
        }
    }

    void commandExit() {
        try {
            JDIConnection c;
            if (this.out != null) {
                this.out.writeInt(0);
                this.out.flush();
            }
            if ((c = this.env.connection()) != null) {
                c.disposeVM();
            }
        }
        catch (IOException ex) {
            this.proc.debug(1, "Exception on JDI exit: %s\n", ex);
        }
    }

    boolean commandLoad(List<ClassTracker.ClassInfo> cil) {
        try {
            this.out.writeInt(1);
            this.out.writeInt(cil.size());
            for (ClassTracker.ClassInfo ci : cil) {
                this.out.writeUTF(ci.getClassName());
                this.out.writeObject(ci.getBytes());
            }
            this.out.flush();
            return this.readAndReportResult();
        }
        catch (IOException ex) {
            this.proc.debug(1, "IOException on remote load operation: %s\n", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String commandInvoke(String classname) throws EvalException, UnresolvedReferenceException {
        block25: {
            try {
                Object object = this.STOP_LOCK;
                synchronized (object) {
                    this.userCodeRunning = true;
                }
                this.out.writeInt(3);
                this.out.writeUTF(classname);
                this.out.flush();
                if (this.readAndReportExecutionResult()) {
                    Object result;
                    Object object2 = result = this.in.readUTF();
                    return object2;
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                if (!this.env.connection().isRunning()) {
                    this.env.shutdown();
                    break block25;
                }
                this.proc.debug(1, "Exception on remote invoke: %s\n", ex);
                String string = "Execution failure: " + ex.getMessage();
                return string;
            }
            finally {
                Object object = this.STOP_LOCK;
                synchronized (object) {
                    this.userCodeRunning = false;
                }
            }
        }
        return "";
    }

    String commandVarValue(String classname, String varname) {
        try {
            this.out.writeInt(5);
            this.out.writeUTF(classname);
            this.out.writeUTF(varname);
            this.out.flush();
            if (this.readAndReportResult()) {
                String result = this.in.readUTF();
                return result;
            }
        }
        catch (EOFException ex) {
            this.env.shutdown();
        }
        catch (IOException ex) {
            this.proc.debug(1, "Exception on remote var value: %s\n", ex);
            return "Execution failure: " + ex.getMessage();
        }
        return "";
    }

    boolean commandAddToClasspath(String cp) {
        try {
            this.out.writeInt(4);
            this.out.writeUTF(cp);
            this.out.flush();
            return this.readAndReportResult();
        }
        catch (IOException ex) {
            throw new InternalError("Classpath addition failed: " + cp, ex);
        }
    }

    boolean commandRedefine(Map<ReferenceType, byte[]> mp) {
        try {
            this.env.vm().redefineClasses(mp);
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        catch (Exception ex) {
            this.proc.debug(1, "Exception on JDI redefine: %s\n", ex);
            return false;
        }
    }

    ReferenceType nameToRef(String name) {
        List rtl = this.env.vm().classesByName(name);
        if (rtl.size() != 1) {
            return null;
        }
        return (ReferenceType)rtl.get(0);
    }

    private boolean readAndReportResult() throws IOException {
        int ok = this.in.readInt();
        switch (ok) {
            case 100: {
                return true;
            }
            case 101: {
                String ex = this.in.readUTF();
                this.proc.debug(1, "Exception on remote operation: %s\n", ex);
                return false;
            }
        }
        this.proc.debug(1, "Bad remote result code: %s\n", ok);
        return false;
    }

    private boolean readAndReportExecutionResult() throws IOException, ClassNotFoundException, EvalException, UnresolvedReferenceException {
        int ok = this.in.readInt();
        switch (ok) {
            case 100: {
                return true;
            }
            case 101: {
                String ex = this.in.readUTF();
                this.proc.debug(1, "Exception on remote operation: %s\n", ex);
                return false;
            }
            case 102: {
                String exceptionClassName = this.in.readUTF();
                String message = this.in.readUTF();
                StackTraceElement[] elems = this.readStackTrace();
                EvalException ee = new EvalException(message, exceptionClassName, elems);
                throw ee;
            }
            case 103: {
                int id = this.in.readInt();
                StackTraceElement[] elems = this.readStackTrace();
                Snippet si = this.maps.getSnippet(id);
                throw new UnresolvedReferenceException((DeclarationSnippet)si, elems);
            }
            case 104: {
                this.proc.out.println("Killed.");
                return false;
            }
        }
        this.proc.debug(1, "Bad remote result code: %s\n", ok);
        return false;
    }

    private StackTraceElement[] readStackTrace() throws IOException {
        int elemCount = this.in.readInt();
        StackTraceElement[] elems = new StackTraceElement[elemCount];
        for (int i = 0; i < elemCount; ++i) {
            String className = this.in.readUTF();
            String methodName = this.in.readUTF();
            String fileName = this.in.readUTF();
            int line = this.in.readInt();
            elems[i] = new StackTraceElement(className, methodName, fileName, line);
        }
        return elems;
    }

    private void jdiGo(int port) {
        String connectorName = "org.openjdk.jdi.CommandLineLaunch";
        String classPath = System.getProperty("java.class.path");
        String bootclassPath = System.getProperty("sun.boot.class.path");
        String javaArgs = "-classpath \"" + classPath + "\" -Xbootclasspath:\"" + bootclassPath + "\"";
        HashMap<String, String> argumentName2Value = new HashMap<String, String>();
        argumentName2Value.put("main", "jdk.internal.jshell.remote.RemoteAgent " + port);
        argumentName2Value.put("options", javaArgs);
        boolean launchImmediately = true;
        int traceFlags = 0;
        this.env.init(connectorName, argumentName2Value, launchImmediately, traceFlags);
        if (this.env.connection().isOpen() && this.env.vm().canBeModified()) {
            this.handler = new JDIEventHandler(this.env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commandStop() {
        Object object = this.STOP_LOCK;
        synchronized (object) {
            block12: {
                if (!this.userCodeRunning) {
                    return;
                }
                VirtualMachine vm = this.handler.env.vm();
                vm.suspend();
                try {
                    for (ThreadReference thread : vm.allThreads()) {
                        Iterator iterator = thread.frames().iterator();
                        while (iterator.hasNext()) {
                            String remoteAgentName = "org.openjdk.tools.internal.jshell.remote.RemoteAgent";
                            StackFrame frame = (StackFrame)iterator.next();
                            if (!remoteAgentName.equals(frame.location().declaringType().name()) || !"commandLoop".equals(frame.location().method().name())) continue;
                            ObjectReference thiz = frame.thisObject();
                            if (((BooleanValue)thiz.getValue(thiz.referenceType().fieldByName("inClientCode"))).value()) {
                                thiz.setValue(thiz.referenceType().fieldByName("expectingStop"), (Value)vm.mirrorOf(true));
                                ObjectReference stopInstance = (ObjectReference)thiz.getValue(thiz.referenceType().fieldByName("stopException"));
                                vm.resume();
                                this.proc.debug(1, "Attempting to stop the client code...\n", new Object[0]);
                                thread.stop(stopInstance);
                                thiz.setValue(thiz.referenceType().fieldByName("expectingStop"), (Value)vm.mirrorOf(false));
                            }
                            break block12;
                        }
                    }
                }
                catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException ex) {
                    this.proc.debug(1, "Exception on remote stop: %s\n", ex);
                }
                finally {
                    vm.resume();
                }
            }
        }
    }

    public static final class PipeInputStream
    extends InputStream {
        public static final int INITIAL_SIZE = 128;
        private int[] buffer = new int[128];
        private int start;
        private int end;
        private boolean closed;

        @Override
        public synchronized int read() {
            while (this.start == this.end) {
                if (this.closed) {
                    return -1;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                int n = this.buffer[this.start];
                return n;
            }
            finally {
                this.start = (this.start + 1) % this.buffer.length;
            }
        }

        public synchronized void write(int b) {
            if (this.closed) {
                throw new IllegalStateException("Already closed.");
            }
            int newEnd = (this.end + 1) % this.buffer.length;
            if (newEnd == this.start) {
                int[] newBuffer = new int[this.buffer.length * 2];
                int rightPart = (this.end > this.start ? this.end : this.buffer.length) - this.start;
                int leftPart = this.end > this.start ? 0 : this.start - 1;
                System.arraycopy(this.buffer, this.start, newBuffer, 0, rightPart);
                System.arraycopy(this.buffer, 0, newBuffer, rightPart, leftPart);
                this.buffer = newBuffer;
                this.start = 0;
                this.end = rightPart + leftPart;
                newEnd = this.end + 1;
            }
            this.buffer[this.end] = b;
            this.end = newEnd;
            this.notifyAll();
        }

        @Override
        public synchronized void close() {
            this.closed = true;
            this.notifyAll();
        }
    }

    private final class DemultiplexInput
    extends Thread {
        private final DataInputStream delegate;
        private final PipeInputStream command;
        private final PrintStream out;
        private final PrintStream err;

        public DemultiplexInput(InputStream input, PipeInputStream command, PrintStream out, PrintStream err) {
            super("output reader");
            this.delegate = new DataInputStream(input);
            this.command = command;
            this.out = out;
            this.err = err;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int nameLen;
                while ((nameLen = this.delegate.read()) != -1) {
                    byte[] name = new byte[nameLen];
                    this.delegate.readFully(name);
                    int dataLen = this.delegate.read();
                    byte[] data = new byte[dataLen];
                    this.delegate.readFully(data);
                    switch (new String(name, "UTF-8")) {
                        case "err": {
                            this.err.write(data);
                            break;
                        }
                        case "out": {
                            this.out.write(data);
                            break;
                        }
                        case "command": {
                            for (byte b : data) {
                                this.command.write(Byte.toUnsignedInt(b));
                            }
                        }
                    }
                }
            }
            catch (IOException ex) {
                ExecutionControl.this.proc.debug(ex, "Failed reading output");
            }
            finally {
                this.command.close();
            }
        }
    }
}

