/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream;

import com.twitter.util.ConstFuture;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.FutureEventListener;
import com.twitter.util.Try;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.acl.AccessControlManager;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.common.util.Sequencer;
import org.apache.distributedlog.exceptions.AlreadyClosedException;
import org.apache.distributedlog.exceptions.DLException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.exceptions.RequestDeniedException;
import org.apache.distributedlog.protocol.util.TwitterFutureUtils;
import org.apache.distributedlog.service.ResponseUtils;
import org.apache.distributedlog.service.stream.AbstractStreamOp;
import org.apache.distributedlog.service.stream.StreamOpStats;
import org.apache.distributedlog.service.stream.WriteOpWithPayload;
import org.apache.distributedlog.service.streamset.Partition;
import org.apache.distributedlog.service.streamset.StreamPartitionConverter;
import org.apache.distributedlog.thrift.service.BulkWriteResponse;
import org.apache.distributedlog.thrift.service.ResponseHeader;
import org.apache.distributedlog.thrift.service.StatusCode;
import org.apache.distributedlog.thrift.service.WriteResponse;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class BulkWriteOp
extends AbstractStreamOp<BulkWriteResponse>
implements WriteOpWithPayload {
    private final List<ByteBuffer> buffers;
    private final long payloadSize;
    private final Counter deniedBulkWriteCounter;
    private final Counter successRecordCounter;
    private final Counter failureRecordCounter;
    private final Counter redirectRecordCounter;
    private final OpStatsLogger latencyStat;
    private final Counter bytes;
    private final Counter bulkWriteBytes;
    private final AccessControlManager accessControlManager;

    private boolean isDefiniteFailure(Try<DLSN> result) {
        boolean def;
        block2: {
            def = false;
            try {
                result.get();
            }
            catch (Exception ex) {
                if (!(ex instanceof OwnershipAcquireFailedException) && !(ex instanceof AlreadyClosedException) && !(ex instanceof LockingException)) break block2;
                def = true;
            }
        }
        return def;
    }

    public BulkWriteOp(String stream, List<ByteBuffer> buffers, StatsLogger statsLogger, StatsLogger perStreamStatsLogger, StreamPartitionConverter streamPartitionConverter, Long checksum, Feature checksumDisabledFeature, AccessControlManager accessControlManager) {
        super(stream, BulkWriteOp.requestStat(statsLogger, "bulkWrite"), checksum, checksumDisabledFeature);
        this.buffers = buffers;
        long total = 0L;
        for (ByteBuffer bb : buffers) {
            total += (long)bb.remaining();
        }
        this.payloadSize = total;
        Partition partition = streamPartitionConverter.convert(stream);
        StreamOpStats streamOpStats = new StreamOpStats(statsLogger, perStreamStatsLogger);
        this.deniedBulkWriteCounter = streamOpStats.requestDeniedCounter("bulkWrite");
        this.successRecordCounter = streamOpStats.recordsCounter("success");
        this.failureRecordCounter = streamOpStats.recordsCounter("failure");
        this.redirectRecordCounter = streamOpStats.recordsCounter("redirect");
        this.bulkWriteBytes = streamOpStats.scopedRequestCounter("bulkWrite", "bytes");
        this.latencyStat = streamOpStats.streamRequestLatencyStat(partition, "bulkWrite");
        this.bytes = streamOpStats.streamRequestCounter(partition, "bulkWrite", "bytes");
        this.accessControlManager = accessControlManager;
        final long size = this.getPayloadSize();
        this.result().addEventListener((FutureEventListener)new FutureEventListener<BulkWriteResponse>(){

            public void onSuccess(BulkWriteResponse response) {
                if (response.getHeader().getCode() == StatusCode.SUCCESS) {
                    BulkWriteOp.this.latencyStat.registerSuccessfulEvent(BulkWriteOp.this.stopwatch().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                    BulkWriteOp.this.bytes.add(size);
                    BulkWriteOp.this.bulkWriteBytes.add(size);
                } else {
                    BulkWriteOp.this.latencyStat.registerFailedEvent(BulkWriteOp.this.stopwatch().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
                }
            }

            public void onFailure(Throwable cause) {
                BulkWriteOp.this.latencyStat.registerFailedEvent(BulkWriteOp.this.stopwatch().elapsed(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
            }
        });
    }

    @Override
    public void preExecute() throws DLException {
        if (!this.accessControlManager.allowWrite(this.stream)) {
            this.deniedBulkWriteCounter.inc();
            throw new RequestDeniedException(this.stream, "bulkWrite");
        }
        super.preExecute();
    }

    @Override
    public long getPayloadSize() {
        return this.payloadSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Future<BulkWriteResponse> executeOp(AsyncLogWriter writer, Sequencer sequencer, Object txnLock) {
        Future futureList;
        Object object = txnLock;
        synchronized (object) {
            List<LogRecord> records = this.asRecordList(this.buffers, sequencer);
            futureList = TwitterFutureUtils.newTFutureList((CompletableFuture)writer.writeBulk(records));
        }
        Future<List<Try<DLSN>>> writes = this.asTryList((Future<List<Future<DLSN>>>)futureList);
        Future response = writes.flatMap((Function1)new AbstractFunction1<List<Try<DLSN>>, Future<BulkWriteResponse>>(){

            public Future<BulkWriteResponse> apply(List<Try<DLSN>> results) {
                Try<DLSN> firstResult;
                ArrayList<WriteResponse> writeResponses = new ArrayList<WriteResponse>(results.size());
                BulkWriteResponse bulkWriteResponse = ResponseUtils.bulkWriteSuccess().setWriteResponses(writeResponses);
                if (results.size() > 0 && BulkWriteOp.this.isDefiniteFailure((Try<DLSN>)(firstResult = results.get(0)))) {
                    return new ConstFuture(firstResult);
                }
                for (Try<DLSN> completedFuture : results) {
                    WriteResponse writeResponse;
                    try {
                        DLSN dlsn = (DLSN)completedFuture.get();
                        writeResponse = ResponseUtils.writeSuccess().setDlsn(dlsn.serialize());
                        writeResponses.add(writeResponse);
                        BulkWriteOp.this.successRecordCounter.inc();
                    }
                    catch (Exception ioe) {
                        writeResponse = ResponseUtils.write(ResponseUtils.exceptionToHeader(ioe));
                        writeResponses.add(writeResponse);
                        if (StatusCode.FOUND == writeResponse.getHeader().getCode()) {
                            BulkWriteOp.this.redirectRecordCounter.inc();
                            continue;
                        }
                        BulkWriteOp.this.failureRecordCounter.inc();
                    }
                }
                return Future.value((Object)bulkWriteResponse);
            }
        });
        return response;
    }

    private List<LogRecord> asRecordList(List<ByteBuffer> buffers, Sequencer sequencer) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>(buffers.size());
        for (ByteBuffer buffer : buffers) {
            byte[] payload = new byte[buffer.remaining()];
            buffer.get(payload);
            records.add(new LogRecord(sequencer.nextId(), payload));
        }
        return records;
    }

    private Future<List<Try<DLSN>>> asTryList(Future<List<Future<DLSN>>> futureList) {
        return futureList.flatMap((Function1)new AbstractFunction1<List<Future<DLSN>>, Future<List<Try<DLSN>>>>(){

            public Future<List<Try<DLSN>>> apply(List<Future<DLSN>> results) {
                return Future$.MODULE$.collectToTry(results);
            }
        });
    }

    @Override
    protected void fail(ResponseHeader header) {
        if (StatusCode.FOUND == header.getCode()) {
            this.redirectRecordCounter.add((long)this.buffers.size());
        } else {
            this.failureRecordCounter.add((long)this.buffers.size());
        }
        this.setResponse(ResponseUtils.bulkWrite(header));
    }

    @Override
    public Future<ResponseHeader> responseHeader() {
        return this.result().map((Function1)new AbstractFunction1<BulkWriteResponse, ResponseHeader>(){

            public ResponseHeader apply(BulkWriteResponse response) {
                return response.getHeader();
            }
        });
    }
}

