/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class DateUtils {
    public static Date now() {
        return new Date();
    }

    public static long toUnixTime(Date date) {
        return DateUtils.toUnixTime(date.getTime());
    }

    public static long nowUnixTime() {
        return DateUtils.toUnixTime(System.currentTimeMillis());
    }

    public static long toUnixTime(long millisSinceEpoch) {
        return TimeUnit.MILLISECONDS.toSeconds(millisSinceEpoch);
    }

    public static Date ago(int calendarField, int amount) {
        return DateUtils.ago(DateUtils.now(), calendarField, amount);
    }

    public static Date ago(Date referenceDate, int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(referenceDate);
        calendar.add(calendarField, -1 * amount);
        return calendar.getTime();
    }

    private DateUtils() {
    }
}

