/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyStoreFileTypeTest
extends ZKTestCase {
    @Test
    public void testGetPropertyValue() {
        Assertions.assertEquals((Object)"PEM", (Object)KeyStoreFileType.PEM.getPropertyValue());
        Assertions.assertEquals((Object)"JKS", (Object)KeyStoreFileType.JKS.getPropertyValue());
        Assertions.assertEquals((Object)"PKCS12", (Object)KeyStoreFileType.PKCS12.getPropertyValue());
        Assertions.assertEquals((Object)"BCFKS", (Object)KeyStoreFileType.BCFKS.getPropertyValue());
    }

    @Test
    public void testFromPropertyValue() {
        Assertions.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromPropertyValue((String)"PEM"));
        Assertions.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValue((String)"JKS"));
        Assertions.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromPropertyValue((String)"PKCS12"));
        Assertions.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromPropertyValue((String)"BCFKS"));
        Assertions.assertNull((Object)KeyStoreFileType.fromPropertyValue((String)""));
        Assertions.assertNull((Object)KeyStoreFileType.fromPropertyValue(null));
    }

    @Test
    public void testFromPropertyValueIgnoresCase() {
        Assertions.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromPropertyValue((String)"pem"));
        Assertions.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValue((String)"jks"));
        Assertions.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromPropertyValue((String)"pkcs12"));
        Assertions.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromPropertyValue((String)"bcfks"));
        Assertions.assertNull((Object)KeyStoreFileType.fromPropertyValue((String)""));
        Assertions.assertNull((Object)KeyStoreFileType.fromPropertyValue(null));
    }

    @Test
    public void testFromPropertyValueThrowsOnBadPropertyValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeyStoreFileType.fromPropertyValue((String)"foobar"));
    }

    @Test
    public void testFromFilename() {
        Assertions.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromFilename((String)"mykey.jks"));
        Assertions.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.jks"));
        Assertions.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromFilename((String)"mykey.pem"));
        Assertions.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.pem"));
        Assertions.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromFilename((String)"mykey.p12"));
        Assertions.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.p12"));
        Assertions.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromFilename((String)"mykey.bcfks"));
        Assertions.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromFilename((String)"/path/to/key/dir/mykey.bcfks"));
    }

    @Test
    public void testFromFilenameThrowsOnBadFileExtension() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeyStoreFileType.fromFilename((String)"prod.key"));
    }

    @Test
    public void testFromPropertyValueOrFileName() {
        Assertions.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"JKS", (String)"prod.key"));
        Assertions.assertEquals((Object)KeyStoreFileType.PEM, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"PEM", (String)"prod.key"));
        Assertions.assertEquals((Object)KeyStoreFileType.PKCS12, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"PKCS12", (String)"prod.key"));
        Assertions.assertEquals((Object)KeyStoreFileType.BCFKS, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"BCFKS", (String)"prod.key"));
        Assertions.assertEquals((Object)KeyStoreFileType.JKS, (Object)KeyStoreFileType.fromPropertyValueOrFileName((String)"", (String)"prod.jks"));
    }

    @Test
    public void testFromPropertyValueOrFileNameThrowsOnBadPropertyValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeyStoreFileType.fromPropertyValueOrFileName((String)"foobar", (String)"prod.jks"));
    }

    @Test
    public void testFromPropertyValueOrFileNameThrowsOnBadFileExtension() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeyStoreFileType.fromPropertyValueOrFileName((String)"", (String)"prod.key"));
    }
}

