/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SaslSuperUserTest
extends ClientBase {
    private static Id otherSaslUser = new Id("sasl", "joe");
    private static Id otherDigestUser;
    private static String oldAuthProvider;
    private static String oldLoginConfig;
    private static String oldSuperUser;
    private AtomicInteger authFailed = new AtomicInteger(0);

    @BeforeClass
    public static void setupStatic() throws Exception {
        oldAuthProvider = System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        File tmpDir = SaslSuperUserTest.createTmpDir();
        File saslConfFile = new File(tmpDir, "jaas.conf");
        FileWriter fwriter = new FileWriter(saslConfFile);
        fwriter.write("Server {\n          org.apache.zookeeper.server.auth.DigestLoginModule required\n          user_super_duper=\"test\";\n};\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"super_duper\"\n       password=\"test\";\n};\n");
        fwriter.close();
        oldLoginConfig = System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        oldSuperUser = System.setProperty("zookeeper.superUser", "super_duper");
        otherDigestUser = new Id("digest", DigestAuthenticationProvider.generateDigest((String)"jack:jack"));
    }

    @AfterClass
    public static void cleanupStatic() {
        if (oldAuthProvider != null) {
            System.setProperty("zookeeper.authProvider.1", oldAuthProvider);
        } else {
            System.clearProperty("zookeeper.authProvider.1");
        }
        oldAuthProvider = null;
        if (oldLoginConfig != null) {
            System.setProperty("java.security.auth.login.config", oldLoginConfig);
        } else {
            System.clearProperty("java.security.auth.login.config");
        }
        oldLoginConfig = null;
        if (oldSuperUser != null) {
            System.setProperty("zookeeper.superUser", oldSuperUser);
        } else {
            System.clearProperty("zookeeper.superUser");
        }
        oldSuperUser = null;
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    @Test
    public void testSuperIsSuper() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/digest_read", null, Arrays.asList(new ACL(1, otherDigestUser)), CreateMode.PERSISTENT);
            zk.create("/digest_read/sub", null, Arrays.asList(new ACL(1, otherDigestUser)), CreateMode.PERSISTENT);
            zk.create("/sasl_read", null, Arrays.asList(new ACL(1, otherSaslUser)), CreateMode.PERSISTENT);
            zk.create("/sasl_read/sub", null, Arrays.asList(new ACL(1, otherSaslUser)), CreateMode.PERSISTENT);
            zk.delete("/digest_read/sub", -1);
            zk.delete("/digest_read", -1);
            zk.delete("/sasl_read/sub", -1);
            zk.delete("/sasl_read", -1);
            Assert.assertEquals((long)this.authFailed.get(), (long)0L);
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslSuperUserTest.this.authFailed.incrementAndGet();
            } else {
                super.process(event);
            }
        }
    }
}

