/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingReadOp;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.checksum.DigestManager;

public class LedgerReader {
    private final ClientContext clientCtx;

    public LedgerReader(BookKeeper bkc) {
        this.clientCtx = bkc.getClientCtx();
    }

    public static SortedMap<Long, ? extends List<BookieId>> bookiesForLedger(LedgerHandle lh) {
        return lh.getLedgerMetadata().getAllEnsembles();
    }

    public void readEntriesFromAllBookies(final LedgerHandle lh, long eid, final BookkeeperInternalCallbacks.GenericCallback<Set<ReadResult<ByteBuf>>> callback) {
        DistributionSchedule.WriteSet writeSet = lh.distributionSchedule.getWriteSet(eid);
        final AtomicInteger numBookies = new AtomicInteger(writeSet.size());
        final HashSet readResults = new HashSet();
        BookkeeperInternalCallbacks.ReadEntryCallback readEntryCallback = new BookkeeperInternalCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void readEntryComplete(int rc, long lid, long eid, ByteBuf buffer, Object ctx) {
                ReadResult<Object> rr;
                BookieSocketAddress bookieAddress = (BookieSocketAddress)ctx;
                if (0 != rc) {
                    rr = new ReadResult<Object>(eid, rc, null, bookieAddress.getSocketAddress());
                } else {
                    try {
                        ByteBuf content = lh.macManager.verifyDigestAndReturnData(eid, buffer);
                        ByteBuf toRet = Unpooled.copiedBuffer((ByteBuf)content);
                        rr = new ReadResult<ByteBuf>(eid, 0, toRet, bookieAddress.getSocketAddress());
                    }
                    catch (BKException.BKDigestMatchException e) {
                        rr = new ReadResult<Object>(eid, -5, null, bookieAddress.getSocketAddress());
                    }
                    finally {
                        buffer.release();
                    }
                }
                readResults.add(rr);
                if (numBookies.decrementAndGet() == 0) {
                    callback.operationComplete(0, (Object)readResults);
                }
            }
        };
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(eid);
        for (int i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            BookieSocketAddress resolvedNetworkAddress = this.clientCtx.getBookieWatcher().getBookieAddressResolver().resolve((BookieId)ensemble.get(idx));
            this.clientCtx.getBookieClient().readEntry((BookieId)ensemble.get(idx), lh.getId(), eid, readEntryCallback, (Object)resolvedNetworkAddress, 0);
        }
    }

    public void forwardReadEntriesFromLastConfirmed(final LedgerHandle lh, final BookkeeperInternalCallbacks.GenericCallback<List<LedgerEntry>> callback) {
        final ArrayList resultList = new ArrayList();
        FutureEventListener<LedgerEntries> readListener = new FutureEventListener<LedgerEntries>(){

            private void readNext(long entryId) {
                PendingReadOp op = new PendingReadOp(lh, LedgerReader.this.clientCtx, entryId, entryId, false);
                op.future().whenComplete((BiConsumer)((Object)this));
                op.submit();
            }

            public void onSuccess(LedgerEntries ledgerEntries) {
                long entryId = -1L;
                for (org.apache.bookkeeper.client.api.LedgerEntry entry : ledgerEntries) {
                    resultList.add(new LedgerEntry((LedgerEntryImpl)entry));
                    entryId = entry.getEntryId();
                }
                try {
                    ledgerEntries.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.readNext(++entryId);
            }

            public void onFailure(Throwable throwable) {
                if (throwable instanceof BKException.BKNoSuchEntryException) {
                    callback.operationComplete(0, (Object)resultList);
                } else {
                    int retCode = throwable instanceof BKException ? ((BKException)throwable).getCode() : -999;
                    callback.operationComplete(retCode, (Object)resultList);
                }
            }
        };
        ReadLastConfirmedOp.LastConfirmedDataCallback readLACCallback = (arg_0, arg_1) -> this.lambda$forwardReadEntriesFromLastConfirmed$0(callback, resultList, lh, (FutureEventListener)readListener, arg_0, arg_1);
        new ReadLastConfirmedOp(this.clientCtx.getBookieClient(), lh.distributionSchedule, lh.macManager, lh.ledgerId, lh.getCurrentEnsemble(), lh.ledgerKey, readLACCallback).initiate();
    }

    public void readLacs(LedgerHandle lh, long eid, BookkeeperInternalCallbacks.GenericCallback<Set<ReadResult<Long>>> callback) {
        DistributionSchedule.WriteSet writeSet = lh.distributionSchedule.getWriteSet(eid);
        AtomicInteger numBookies = new AtomicInteger(writeSet.size());
        HashSet readResults = new HashSet();
        BookkeeperInternalCallbacks.ReadEntryCallback readEntryCallback = (rc, lid, eid1, buffer, ctx) -> {
            ReadResult<Object> rr;
            InetSocketAddress bookieAddress = (InetSocketAddress)ctx;
            if (0 != rc) {
                rr = new ReadResult<Object>(eid1, rc, null, bookieAddress);
            } else {
                try {
                    DigestManager.RecoveryData data = lh.macManager.verifyDigestAndReturnLastConfirmed(buffer);
                    rr = new ReadResult<Long>(eid1, 0, data.getLastAddConfirmed(), bookieAddress);
                }
                catch (BKException.BKDigestMatchException e) {
                    rr = new ReadResult<Object>(eid1, -5, null, bookieAddress);
                }
            }
            readResults.add(rr);
            if (numBookies.decrementAndGet() == 0) {
                callback.operationComplete(0, (Object)readResults);
            }
        };
        List ensemble = lh.getLedgerMetadata().getEnsembleAt(eid);
        for (int i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            this.clientCtx.getBookieClient().readEntry((BookieId)ensemble.get(idx), lh.getId(), eid, readEntryCallback, ensemble.get(idx), 0);
        }
    }

    private /* synthetic */ void lambda$forwardReadEntriesFromLastConfirmed$0(BookkeeperInternalCallbacks.GenericCallback callback, List resultList, LedgerHandle lh, FutureEventListener readListener, int rc, DigestManager.RecoveryData recoveryData) {
        if (0 != rc) {
            callback.operationComplete(rc, (Object)resultList);
            return;
        }
        if (-1L >= recoveryData.getLastAddConfirmed()) {
            callback.operationComplete(0, (Object)resultList);
            return;
        }
        long entryId = recoveryData.getLastAddConfirmed();
        PendingReadOp op = new PendingReadOp(lh, this.clientCtx, entryId, entryId, false);
        op.future().whenComplete((BiConsumer)readListener);
        op.submit();
    }

    public static class ReadResult<T> {
        final long entryId;
        final int rc;
        final T value;
        final InetSocketAddress srcAddr;

        ReadResult(long entryId, int rc, T value, InetSocketAddress srcAddr) {
            this.entryId = entryId;
            this.rc = rc;
            this.value = value;
            this.srcAddr = srcAddr;
        }

        public long getEntryId() {
            return this.entryId;
        }

        public int getResultCode() {
            return this.rc;
        }

        public T getValue() {
            return this.value;
        }

        public InetSocketAddress getBookieAddress() {
            return this.srcAddr;
        }
    }
}

