<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

> **PLEASE update this file if you add new job or change name/trigger phrase in groovy files.**

## Beam Jenkins

**DEPRECATED:** As of November 2023, Beam CI has migrated to self-hosted GitHub Action: [link](https://github.com/apache/beam/blob/master/.github/workflows/README.md). New tests should be setup by GitHub Action, and the Jenkins jobs listed below is planned to be shutdown.

Beam Jenkins overview page: [link](https://ci-beam.apache.org/)

### PreCommit Jobs

All PreCommit Jobs have been migrated to GitHub Action.

### PostCommit Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PostCommit_BeamMetrics_Publish | [cron](https://ci-beam.apache.org/job/beam_PostCommit_BeamMetrics_Publish/) | N/A | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_BeamMetrics_Publish/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_BeamMetrics_Publish) |
| beam_PostCommit_XVR_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink_PR/) | `Run XVR_Flink PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink) |
| beam_PostCommit_XVR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza_PR/) | `Run XVR_Samza PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza) |
| beam_PostCommit_XVR_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark_PR/) | `Run XVR_Spark PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark) |
| beam_PostCommit_XVR_Spark3 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3_PR) | `Run XVR_Spark3 PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3/) |
| beam_PostCommit_XVR_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct_PR/) | `Run XVR_Direct PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct) |
| beam_PostCommit_XVR_Dataflow | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow_PR/) | `Run XVR_Dataflow PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow/) |
| beam_PostCommit_Go | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_PR/) | `Run Go PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go) |
| beam_PostCommit_Go_VR_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink_PR/) | `Run Go Flink ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink/) |
| beam_PostCommit_Go_VR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza_PR/) | `Run Go Samza ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza/) |
| beam_PostCommit_Go_VR_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark_PR/) | `Run Go Spark ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark/) |
| beam_PostCommit_Java_Hadoop_Versions | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions_PR/) | `Run PostCommit_Java_Hadoop_Versions` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions/) |
| beam_PostCommit_Java | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PR/) | `Run Java PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java) |
| beam_PostCommit_Java_DataflowV1 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1_PR/) | `Run PostCommit_Java_Dataflow` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1/) |
| beam_PostCommit_Java_DataflowV2 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2_PR/) | `Run PostCommit_Java_DataflowV2` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2/) |
| beam_PostCommit_Java_InfluxDbIO_IT | [cron](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_InfluxDbIO_IT/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_SingleStoreIO_IT_PR/) | `Run Java InfluxDbIO_IT` | [![Build Status](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_InfluxDbIO_IT/badge/icon)](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_InfluxDbIO_IT/) |
| beam_PostCommit_Java_Nexmark_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow_PR/) | `Dataflow Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow) |
| beam_PostCommit_Java_Nexmark_Dataflow_V2 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_DataflowV2_PR/) | `Run Dataflow Runner V2 Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2/) |
| beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/badge/icon) | `Dataflow Runner V2 Java 11 Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/) |
| beam_PostCommit_Java_Nexmark_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct_PR/) | `Direct Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct) |
| beam_PostCommit_Java_Nexmark_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink_PR/) | `Flink Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink) |
| beam_PostCommit_Java_Nexmark_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark_PR/) | `Spark Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark) |
| beam_PostCommit_Java_PVR_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch_PR/) | `Run Java Flink PortableValidatesRunner Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch) |
| beam_PostCommit_Java_PVR_Flink_Streaming | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming_PR/) | `Run Java Flink PortableValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming) |
| beam_PostCommit_Java_PVR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza_PR/) | `Run Java Samza PortableValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza) |
| beam_PostCommit_Java_PVR_Spark_Batch | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch_PR/) | `Run Java Spark PortableValidatesRunner Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch) |
| beam_PostCommit_Java_PVR_Spark2_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming_PR/) | `Run Java Spark v2 PortableValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming/) |
| beam_PostCommit_Java_PVR_Spark3_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming_PR/) | `Run Java Spark v3 PortableValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming/) |
| beam_PostCommit_Java_SingleStoreIO_IT | [cron](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_SingleStoreIO_IT/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_SingleStoreIO_IT_PR/) | `Run Java SingleStoreIO_IT` | [![Build Status](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_SingleStoreIO_IT/badge/icon)](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_SingleStoreIO_IT/) |
| beam_PostCommit_Java_Dataflow_Examples_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11_PR/) | `Run Java examples on Dataflow Java 11` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11) |
| beam_PostCommit_Java_Examples_Dataflow_V2 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2/) | `Run Java Examples on Dataflow Runner V2` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2) |
| beam_PostCommit_Java_Examples_Dataflow_V2_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples__Dataflow_V2_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples__Dataflow_V2_Java11/) | `Run Java 11 Examples on Dataflow Runner V2` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2_Java11) |
| beam_PostCommit_Java_Jpms_Dataflow_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11_PR/) | `Run Jpms Dataflow Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11/) |
| beam_PostCommit_Java_Jpms_Direct_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11_PR/) | `Run Jpms Direct Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11/) |
| beam_PostCommit_Java_Jpms_Flink_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11_PR/) | `Run Jpms Flink Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11/) |
| beam_PostCommit_Java_Jpms_Spark_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11_PR/) | `Run Jpms Spark Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11/badge/icon) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11_PR/) | `Run Dataflow ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11) |
| beam_PostCommit_Java_ValidatesRunner_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_PR/) | `Run Direct ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct/) |
| beam_PostCommit_Java_ValidatesRunner_Direct_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11_PR) | `Run Direct ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_PR/) | `Run Dataflow ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming_PR/) | `Run Dataflow Streaming ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming/) |
| beam_PostCommit_Java_ValidatesRunner_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink_PR/) | `Run Flink ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink) |
| beam_PostCommit_Java_ValidatesRunner_Flink_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11_PR/) | `Run Flink ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11/) |
| beam_PostCommit_Java_ValidatesRunner_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza_PR/) | `Run Samza ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza) |
| beam_PostCommit_Java_ValidatesRunner_Twister2 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2_PR/) | `Run Twister2 ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2) |
| beam_PostCommit_Java_ValidatesRunner_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark_PR/) | `Run Spark ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark) |
| beam_PostCommit_Java_ValidatesRunner_Spark_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11_PR) | `Run Spark ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11/) |
| beam_PostCommit_Java_ValidatesRunner_ULR | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR_PR) | `Run ULR Loopback ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR/) |
| beam_PostCommit_Java_VR_Dataflow_V2 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_PR/) | `Run Java Dataflow V2 ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2/) |
| beam_PostCommit_Java_VR_Dataflow_V2_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming_PR/) | `Run Java Dataflow V2 ValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming/) |
| beam_PostCommit_Javadoc | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc_PR/) | `Run Javadoc PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc) |
| beam_PostCommit_PortableJar_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink_PR/) | `Run PortableJar_Flink PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink) |
| beam_PostCommit_PortableJar_Spark | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark_PR/) | `Run PortableJar_Spark PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark/) |
| beam_PostCommit_Java_Sickbay | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay_PR/) | `Run Java Sickbay` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay/) |
| beam_PostCommit_Py_VR_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow_PR/) | `Run Python Dataflow ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow) |
| beam_PostCommit_Py_ValCont | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_PR/) | `Run Python Dataflow ValidatesContainer` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont) |
| beam_PostCommit_Python_VR_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink_PR/) | `Run Python Flink ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink) |
| beam_PostCommit_Python_VR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza_PR/) | `Run Python Samza ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza) |
| beam_PostCommit_Py_ValCont_with_RC | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC_PR/) | `Run Python RC Dataflow ValidatesContainer` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC) |
| beam_PostCommit_Python_Examples_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct_PR/) | `Run Python Examples_Direct` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct/) |
| beam_PostCommit_Python_Examples_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow_PR/) | `Run Python Examples_Dataflow` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow/) |
| beam_PostCommit_Python_Examples_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink_PR/) | `Run Python Examples_Flink` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink/) |
| beam_PostCommit_Python_Examples_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark_PR/) | `Run Python Examples_Spark` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark/) |
| beam_PostCommit_Python_Chicago_Taxi_Example_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow_PR/) | `Run Chicago Taxi on Dataflow` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow) |
| beam_PostCommit_Python_Chicago_Taxi_Example_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink_PR/) | `Run Chicago Taxi on Flink` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink) |
| beam_PostCommit_Python_MongoDBIO_IT | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT_PR/) | `Run Python MongoDBIO_IT` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT) |
| beam_PostCommit_Python_VR_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark/) | `Run Python Spark ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark) |
| beam_PostCommit_Python_Xlang_Gcp_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct_PR/) | `Run Python_Xlang_Gcp_Direct PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct/) |
| beam_PostCommit_Python_Xlang_Gcp_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow_PR/) | `Run Python_Xlang_Gcp_Dataflow PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow/) |
| beam_PostCommit_Python_Xlang_IO_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow_PR/) | `Run Python_Xlang_IO_Dataflow PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow/|
| beam_PostCommit_Python38 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python38), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python38_PR/) | `Run Python 3.8 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python38/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python38) |
| beam_PostCommit_Python39 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python39), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python39_PR/) | `Run Python 3.9 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python39/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python39) |
| beam_PostCommit_Python310 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python310), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python310_PR/) | `Run Python 3.10 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python310/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python310) |
| beam_PostCommit_Python311 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python311), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python311_PR/) | `Run Python 3.11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python311/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python311) |
| beam_PostCommit_Sickbay_Python38 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python38), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python38_PR/) | `Run Python 3.8 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python38/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python38) |
| beam_PostCommit_Sickbay_Python39 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python39), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python39_PR/) | `Run Python 3.9 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python39/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python39) |
| beam_PostCommit_Sickbay_Python310 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python310), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python310_PR/) | `Run Python 3.10 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python310/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python310) |
| beam_PostCommit_Sickbay_Python311 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python311), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python311_PR/) | `Run Python 3.11 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python311/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python311) |
| beam_PostCommit_SQL | [cron](https://ci-beam.apache.org/job/beam_PostCommit_SQL/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SQL_PR/) | `Run SQL PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_SQL/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_SQL) |
| beam_PostCommit_Website_Publish | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Website_Publish/) | N/A | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Website_Publish/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Website_Publish) |
| beam_PostCommit_Website_Test | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Website_Test/) | `Run Full Website Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Website_Test/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Website_Test) |

### Performance Jobs

All Performance Jobs have been migrated to GitHub Action.

### Load test Jobs

All LoadTest Jobs have been migrated to GitHub Action.

### Inventory Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_Inventory_apache-beam-jenkins-1 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-1/) | `Run inventory apache-beam-jenkins-1` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-1/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-1) |
| beam_Inventory_apache-beam-jenkins-2 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-2/) | `Run inventory apache-beam-jenkins-2` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-2/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-2) |
| beam_Inventory_apache-beam-jenkins-3 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-3/) | `Run inventory apache-beam-jenkins-3` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-3/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-3) |
| beam_Inventory_apache-beam-jenkins-4 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-4/) | `Run inventory apache-beam-jenkins-4` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-4/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-4) |
| beam_Inventory_apache-beam-jenkins-5 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-5/) | `Run inventory apache-beam-jenkins-5` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-5/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-5) |
| beam_Inventory_apache-beam-jenkins-6 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-6/) | `Run inventory apache-beam-jenkins-6` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-6/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-6) |
| beam_Inventory_apache-beam-jenkins-7 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-7/) | `Run inventory apache-beam-jenkins-7` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-7/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-7) |
| beam_Inventory_apache-beam-jenkins-8 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-8/) | `Run inventory apache-beam-jenkins-8` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-8/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-8) |
| beam_Inventory_apache-beam-jenkins-9 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-9/) | `Run inventory apache-beam-jenkins-9` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-9/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-9) |
| beam_Inventory_apache-beam-jenkins-10 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-10/) | `Run inventory apache-beam-jenkins-10` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-10/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-10) |
| beam_Inventory_apache-beam-jenkins-11 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-11/) | `Run inventory apache-beam-jenkins-11` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-11/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-11) |
| beam_Inventory_apache-beam-jenkins-12 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-12/) | `Run inventory apache-beam-jenkins-12` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-12/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-12) |
| beam_Inventory_apache-beam-jenkins-13 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-13/) | `Run inventory apache-beam-jenkins-13` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-13/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-13) |
| beam_Inventory_apache-beam-jenkins-14 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-14/) | `Run inventory apache-beam-jenkins-14` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-14/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-14) |
| beam_Inventory_apache-beam-jenkins-15 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-15/) | `Run inventory apache-beam-jenkins-15` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-15/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-15) |
| beam_Inventory_apache-beam-jenkins-16 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-16/) | `Run inventory apache-beam-jenkins-16` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-16/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-16) |

### Other Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_Metrics_Report | [cron](https://ci-beam.apache.org/job/beam_Metrics_Report/) | `Run Metrics Report` | [![Build Status](https://ci-beam.apache.org/job/beam_Metrics_Report/badge/icon)](https://ci-beam.apache.org/job/beam_Metrics_Report) |
| beam_Release_NightlySnapshot | [cron](https://ci-beam.apache.org/job/beam_Release_NightlySnapshot/) | `Run Gradle Publish` | [![Build Status](https://ci-beam.apache.org/job/beam_Release_NightlySnapshot/badge/icon)](https://ci-beam.apache.org/job/beam_Release_NightlySnapshot) |
| beam_Release_Python_NightlySnapshot | [cron](https://ci-beam.apache.org/job/beam_Release_Python_NightlySnapshot/) | `Run Python Publish` | [![Build Status](https://ci-beam.apache.org/job/beam_Release_Python_NightlySnapshot/badge/icon)](https://ci-beam.apache.org/job/beam_Release_Python_NightlySnapshot) |
| beam_PostRelease_NightlySnapshot | [cron](https://ci-beam.apache.org/job/beam_PostRelease_NightlySnapshot/) | `Run Dataflow PostRelease` | [![Build Status](https://ci-beam.apache.org/job/beam_PostRelease_NightlySnapshot/badge/icon)](https://ci-beam.apache.org/job/beam_PostRelease_NightlySnapshot) |
| beam_Prober_CommunityMetrics | [cron](https://ci-beam.apache.org/job/beam_Prober_CommunityMetrics/) | `Run Community Metrics Prober` | [![Build Status](https://ci-beam.apache.org/job/beam_Prober_CommunityMetrics/badge/icon)](https://ci-beam.apache.org/job/beam_Prober_CommunityMetrics) |
| beam_SeedJob | [cron](https://ci-beam.apache.org/job/beam_SeedJob/), [standalone](https://ci-beam.apache.org/job/beam_SeedJob_Standalone/) | `Run Seed Job` | [![Build Status](https://ci-beam.apache.org/job/beam_SeedJob/badge/icon)](https://ci-beam.apache.org/job/beam_SeedJob) |
| beam_sonarqube_report | [cron](https://ci-beam.apache.org/job/beam_sonarqube_report/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_sonarqube_report/badge/icon)](https://ci-beam.apache.org/job/beam_sonarqube_report/) |
| beam_CancelStaleDataflowJobs | [cron](https://ci-beam.apache.org/job/beam_CancelStaleDataflowJobs/)| `Run Cancel Stale Dataflow Jobs` | [![Build Status](https://ci-beam.apache.org/job/beam_CancelStaleDataflowJobs/badge/icon)](https://ci-beam.apache.org/job/beam_CancelStaleDataflowJobs/) |
| beam_CleanUpGCPResources | [cron](https://ci-beam.apache.org/job/beam_CleanUpGCPResources/)| `Run Clean GCP Resources` | [![Build Status](https://ci-beam.apache.org/job/beam_CleanUpGCPResources/badge/icon)](https://ci-beam.apache.org/job/beam_CleanUpGCPResources/) |
| beam_Clean_tmp_directory | [cron](https://ci-beam.apache.org/job/beam_Clean_tmp_directory/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_Clean_tmp_directory/badge/icon)](https://ci-beam.apache.org/job/beam_Clean_tmp_directory/) |
| beam_Publish_Beam_SDK_Snapshots | [cron](https://ci-beam.apache.org/job/beam_Publish_Beam_SDK_Snapshots/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_Publish_Beam_SDK_Snapshots/badge/icon)](https://ci-beam.apache.org/job/beam_Publish_Beam_SDK_Snapshots/) |
| beam_Publish_Docker_Snapshots | [cron](https://ci-beam.apache.org/job/beam_Publish_Docker_Snapshots/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_Publish_Docker_Snapshots/badge/icon)](https://ci-beam.apache.org/job/beam_Publish_Docker_Snapshots/) |
| beam_PostRelease_Python_Candidate | [cron](https://ci-beam.apache.org/job/beam_PostRelease_Python_Candidate/)| `Run Python ReleaseCandidate` | [![Build Status](https://ci-beam.apache.org/job/beam_PostRelease_Python_Candidate/badge/icon)](https://ci-beam.apache.org/job/beam_PostRelease_Python_Candidate/) |

### Notes:

* To rerun full set of PreCommit jobs in PR, comment following trigger phrase:

```
retest this please
```

* Last update (mm/dd/yyyy): 11/27/2023
