/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.system;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(BackgroundThread.class);
    private volatile boolean interruptible = true;
    private volatile boolean softInterrupted = false;

    public BackgroundThread(String name, boolean daemon) {
        this.setName(name + ":" + this.getId());
        this.setDaemon(daemon);
    }

    @Override
    public void run() {
        while (!BackgroundThread.interrupted() && !this.softInterrupted) {
            try {
                this.waitCondition();
            }
            catch (InterruptedException e) {
                log.debug("Interrupted in background thread wait condition", (Throwable)e);
                break;
            }
            if (BackgroundThread.interrupted()) break;
            this.interruptible = false;
            try {
                this.action();
            }
            catch (Throwable e) {
                log.error("Exception while executing action on background thread", e);
            }
            finally {
                this.interruptible = true;
            }
        }
        try {
            this.cleanup();
        }
        catch (Throwable e) {
            log.error("Exception while executing cleanup on background thread", e);
        }
    }

    protected abstract void waitCondition() throws InterruptedException;

    protected abstract void action();

    protected void cleanup() {
    }

    public void close(long maxWait, TimeUnit unit) {
        if (!this.isAlive()) {
            log.warn("Already closed: {}", (Object)this);
            return;
        }
        long maxWaitMs = TimeUnit.MILLISECONDS.convert(maxWait, unit);
        this.softInterrupted = true;
        if (this.interruptible) {
            this.interrupt();
        }
        try {
            this.join(maxWaitMs);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for thread {} to join", (Throwable)e);
        }
        if (this.isAlive()) {
            log.error("Thread {} did not terminate in time [{}]. This could mean that important clean up functions could not be called.", (Object)this.getName(), (Object)maxWaitMs);
        }
    }
}

