/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction.lock;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.transaction.lock.TransactionLock;

public class CombinerLock
implements TransactionLock {
    private final TransactionLock first;
    private final TransactionLock second;
    private final TimestampProvider times;

    public CombinerLock(TransactionLock first, TransactionLock second, TimestampProvider times) {
        this.first = first;
        this.second = second;
        this.times = times;
        Preconditions.checkNotNull((Object)this.first);
        Preconditions.checkNotNull((Object)this.second);
        Preconditions.checkNotNull((Object)this.times);
    }

    @Override
    public void lock(Duration timeout) {
        Timer t = this.times.getTimer().start();
        this.first.lock(timeout);
        Duration remainingTimeout = timeout.sub(t.elapsed());
        try {
            this.second.lock(remainingTimeout);
        }
        catch (RuntimeException e) {
            this.first.unlock();
            throw e;
        }
    }

    @Override
    public void unlock() {
        try {
            this.first.unlock();
        }
        finally {
            this.second.unlock();
        }
    }

    @Override
    public boolean inUse() {
        return this.first.inUse() || this.second.inUse();
    }
}

