/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.log;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Timestamp;
import com.thinkaurelius.titan.core.log.Change;
import com.thinkaurelius.titan.core.log.ChangeProcessor;
import com.thinkaurelius.titan.core.log.LogProcessorBuilder;
import com.thinkaurelius.titan.core.log.LogProcessorFramework;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.log.MessageReader;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.log.LogTxMeta;
import com.thinkaurelius.titan.graphdb.database.log.TransactionLogHeader;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.log.ModificationDeserializer;
import com.thinkaurelius.titan.graphdb.log.StandardChangeState;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionId;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.vertices.StandardVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLogProcessorFramework
implements LogProcessorFramework {
    private static final Logger logger = LoggerFactory.getLogger(StandardLogProcessorFramework.class);
    private final StandardTitanGraph graph;
    private final Serializer serializer;
    private final TimestampProvider times;
    private final Map<String, Log> processorLogs;
    private boolean isOpen = true;

    public StandardLogProcessorFramework(StandardTitanGraph graph) {
        Preconditions.checkArgument((graph != null && graph.isOpen() ? 1 : 0) != 0);
        this.graph = graph;
        this.serializer = graph.getDataSerializer();
        this.times = graph.getConfiguration().getTimestampProvider();
        this.processorLogs = new HashMap<String, Log>();
    }

    private void checkOpen() {
        Preconditions.checkState((boolean)this.isOpen, (Object)"Transaction log framework has already been closed");
    }

    @Override
    public synchronized boolean removeLogProcessor(String logIdentifier) {
        this.checkOpen();
        if (this.processorLogs.containsKey(logIdentifier)) {
            try {
                this.processorLogs.get(logIdentifier).close();
            }
            catch (BackendException e) {
                throw new TitanException("Could not close transaction log: " + logIdentifier, e);
            }
            this.processorLogs.remove(logIdentifier);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void shutdown() throws TitanException {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        try {
            for (Log log : this.processorLogs.values()) {
                log.close();
            }
            this.processorLogs.clear();
        }
        catch (BackendException e) {
            throw new TitanException(e);
        }
    }

    @Override
    public LogProcessorBuilder addLogProcessor(String logIdentifier) {
        return new Builder(logIdentifier);
    }

    private class MsgReaderConverter
    implements MessageReader {
        private final String userlogName;
        private final ChangeProcessor processor;
        private final int retryAttempts;

        private MsgReaderConverter(String userLogName, ChangeProcessor processor, int retryAttempts) {
            this.userlogName = userLogName;
            this.processor = processor;
            this.retryAttempts = retryAttempts;
        }

        private void readRelations(TransactionLogHeader.Entry txentry, StandardTitanTx tx, StandardChangeState changes) {
            for (TransactionLogHeader.Modification modification : txentry.getContentAsModifications(StandardLogProcessorFramework.this.serializer)) {
                InternalRelation rel = ModificationDeserializer.parseRelation(modification, tx);
                Change state = modification.state;
                if (rel.getType().equals(BaseKey.VertexExists) && !(rel.getVertex(0) instanceof TitanSchemaElement)) {
                    if (state == Change.REMOVED) {
                        ((StandardVertex)rel.getVertex(0)).updateLifeCycle(ElementLifeCycle.Event.REMOVED);
                    }
                    changes.addVertex(rel.getVertex(0), state);
                    continue;
                }
                if (rel.isHidden()) continue;
                changes.addRelation(rel, state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(Message message) {
            for (int i = 1; i <= this.retryAttempts; ++i) {
                StandardTitanTx tx = (StandardTitanTx)StandardLogProcessorFramework.this.graph.newTransaction();
                StandardChangeState changes = new StandardChangeState();
                StandardTransactionId transactionId = null;
                try {
                    ReadBuffer content = message.getContent().asReadBuffer();
                    String senderId = message.getSenderId();
                    TransactionLogHeader.Entry txentry = TransactionLogHeader.parse(content, StandardLogProcessorFramework.this.serializer, StandardLogProcessorFramework.this.times);
                    transactionId = txentry.getMetadata().containsKey((Object)LogTxMeta.SOURCE_TRANSACTION) ? (StandardTransactionId)txentry.getMetadata().get((Object)LogTxMeta.SOURCE_TRANSACTION) : new StandardTransactionId(senderId, txentry.getHeader().getId(), new Timestamp(txentry.getHeader().getTimestamp(StandardLogProcessorFramework.this.times.getUnit()), StandardLogProcessorFramework.this.times.getUnit()));
                    this.readRelations(txentry, tx, changes);
                }
                catch (Throwable e) {
                    tx.rollback();
                    logger.error("Encountered exception [{}] when preparing processor [{}] for user log [{}] on attempt {} of {}", new Object[]{e.getMessage(), this.processor, this.userlogName, i, this.retryAttempts});
                    logger.error("Full exception: ", e);
                    continue;
                }
                assert (transactionId != null);
                try {
                    this.processor.process(tx, transactionId, changes);
                    return;
                }
                catch (Throwable e) {
                    tx.rollback();
                    tx = null;
                    logger.error("Encountered exception [{}] when running processor [{}] for user log [{}] on attempt {} of {}", new Object[]{e.getMessage(), this.processor, this.userlogName, i, this.retryAttempts});
                    logger.error("Full exception: ", e);
                    continue;
                }
                finally {
                    if (tx != null) {
                        tx.commit();
                    }
                }
            }
        }
    }

    private class Builder
    implements LogProcessorBuilder {
        private final String userLogName;
        private final List<ChangeProcessor> processors;
        private String readMarkerName = null;
        private Timestamp startTime = null;
        private int retryAttempts = 1;

        private Builder(String userLogName) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)userLogName));
            this.userLogName = userLogName;
            this.processors = new ArrayList<ChangeProcessor>();
        }

        @Override
        public String getLogIdentifier() {
            return this.userLogName;
        }

        @Override
        public LogProcessorBuilder setProcessorIdentifier(String name) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
            this.readMarkerName = name;
            return this;
        }

        @Override
        public LogProcessorBuilder setStartTime(long sinceEpoch, TimeUnit unit) {
            this.startTime = new Timestamp(sinceEpoch, unit);
            return this;
        }

        @Override
        public LogProcessorBuilder setStartTimeNow() {
            this.startTime = null;
            return this;
        }

        @Override
        public LogProcessorBuilder addProcessor(ChangeProcessor processor) {
            Preconditions.checkArgument((processor != null ? 1 : 0) != 0);
            this.processors.add(processor);
            return this;
        }

        @Override
        public LogProcessorBuilder setRetryAttempts(int attempts) {
            Preconditions.checkArgument((attempts > 0 ? 1 : 0) != 0, (String)"Invalid number: %s", (Object[])new Object[]{attempts});
            this.retryAttempts = attempts;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void build() {
            Preconditions.checkArgument((!this.processors.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one processor");
            ReadMarker readMarker = this.startTime == null && this.readMarkerName == null ? ReadMarker.fromNow() : (this.readMarkerName == null ? ReadMarker.fromTime(this.startTime.sinceEpoch(this.startTime.getNativeUnit()), this.startTime.getNativeUnit()) : (this.startTime == null ? ReadMarker.fromIdentifierOrNow(this.readMarkerName) : ReadMarker.fromIdentifierOrTime(this.readMarkerName, this.startTime.sinceEpoch(this.startTime.getNativeUnit()), this.startTime.getNativeUnit())));
            StandardLogProcessorFramework standardLogProcessorFramework = StandardLogProcessorFramework.this;
            synchronized (standardLogProcessorFramework) {
                Preconditions.checkArgument((!StandardLogProcessorFramework.this.processorLogs.containsKey(this.userLogName) ? 1 : 0) != 0, (String)"Processors have already been registered for user log: %s", (Object[])new Object[]{this.userLogName});
                try {
                    Log log = StandardLogProcessorFramework.this.graph.getBackend().getUserLog(this.userLogName);
                    log.registerReaders(readMarker, Iterables.transform(this.processors, (Function)new Function<ChangeProcessor, MessageReader>(){

                        @Nullable
                        public MessageReader apply(@Nullable ChangeProcessor changeProcessor) {
                            return new MsgReaderConverter(Builder.this.userLogName, changeProcessor, Builder.this.retryAttempts);
                        }
                    }));
                }
                catch (BackendException e) {
                    throw new TitanException("Could not open user transaction log for name: " + this.userLogName, e);
                }
            }
        }
    }
}

