/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.EdgeLabelMaker;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.PropertyKeyMaker;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanConfiguration;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.TransactionalConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.UserModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.KCVSConfiguration;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.cache.SchemaCache;
import com.thinkaurelius.titan.graphdb.database.management.ManagementLogger;
import com.thinkaurelius.titan.graphdb.database.management.MgmtLogType;
import com.thinkaurelius.titan.graphdb.database.management.ModifierType;
import com.thinkaurelius.titan.graphdb.database.management.RelationTypeIndexWrapper;
import com.thinkaurelius.titan.graphdb.database.management.TitanGraphIndexWrapper;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.internal.Token;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.ParameterIndexField;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.types.StandardPropertyKeyMaker;
import com.thinkaurelius.titan.graphdb.types.StandardRelationTypeMaker;
import com.thinkaurelius.titan.graphdb.types.StandardVertexLabelMaker;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionDescription;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.indextype.IndexTypeWrapper;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.vertices.EdgeLabelVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.PropertyKeyVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.RelationTypeVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.util.encoding.ConversionHelper;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementSystem
implements TitanManagement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementSystem.class);
    private static final String CURRENT_INSTANCE_SUFFIX = "(current)";
    private final StandardTitanGraph graph;
    private final Log sysLog;
    private final ManagementLogger mgmtLogger;
    private final KCVSConfiguration baseConfig;
    private final TransactionalConfiguration transactionalConfig;
    private final ModifiableConfiguration modifyConfig;
    private final UserModifiableConfiguration userConfig;
    private final SchemaCache schemaCache;
    private final StandardTitanTx transaction;
    private final Set<TitanSchemaVertex> updatedTypes;
    private final Set<Callable<Boolean>> updatedTypeTriggers;
    private final Timepoint txStartTime;
    private boolean graphShutdownRequired;
    private boolean isOpen;
    private final UserModifiableConfiguration.ConfigVerifier configVerifier = new UserModifiableConfiguration.ConfigVerifier(){

        @Override
        public void verifyModification(ConfigOption option) {
            Preconditions.checkArgument((option.getType() != ConfigOption.Type.FIXED ? 1 : 0) != 0, (String)"Cannot change the fixed configuration option: %s", (Object[])new Object[]{option});
            Preconditions.checkArgument((option.getType() != ConfigOption.Type.LOCAL ? 1 : 0) != 0, (String)"Cannot change the local configuration option: %s", (Object[])new Object[]{option});
            if (option.getType() == ConfigOption.Type.GLOBAL_OFFLINE) {
                Set<String> openInstances = ManagementSystem.this.getOpenInstancesInternal();
                assert (openInstances.size() > 0);
                Preconditions.checkArgument((openInstances.size() < 2 ? 1 : 0) != 0, (String)"Cannot change offline config option [%s] since multiple instances are currently open: %s", (Object[])new Object[]{option, openInstances});
                Preconditions.checkArgument((boolean)openInstances.contains(ManagementSystem.this.graph.getConfiguration().getUniqueGraphId()), (Object)("Only one open instance (" + openInstances.iterator().next() + "), but it's not the current one (" + ManagementSystem.this.graph.getConfiguration().getUniqueGraphId() + ")"));
                ManagementSystem.this.graphShutdownRequired = true;
            }
        }
    };

    public ManagementSystem(StandardTitanGraph graph, KCVSConfiguration config, Log sysLog, ManagementLogger mgmtLogger, SchemaCache schemaCache) {
        Preconditions.checkArgument((config != null && graph != null && sysLog != null && mgmtLogger != null ? 1 : 0) != 0);
        this.graph = graph;
        this.baseConfig = config;
        this.sysLog = sysLog;
        this.mgmtLogger = mgmtLogger;
        this.schemaCache = schemaCache;
        this.transactionalConfig = new TransactionalConfiguration(this.baseConfig);
        this.modifyConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.transactionalConfig, BasicConfiguration.Restriction.GLOBAL);
        this.userConfig = new UserModifiableConfiguration(this.modifyConfig, this.configVerifier);
        this.updatedTypes = new HashSet<TitanSchemaVertex>();
        this.updatedTypeTriggers = new HashSet<Callable<Boolean>>();
        this.graphShutdownRequired = false;
        this.transaction = (StandardTitanTx)graph.buildTransaction().disableBatchLoading().start();
        this.txStartTime = graph.getConfiguration().getTimestampProvider().getTime();
        this.isOpen = true;
    }

    public Set<String> getOpenInstancesInternal() {
        HashSet openInstances = Sets.newHashSet(this.modifyConfig.getContainedNamespaces(GraphDatabaseConfiguration.REGISTRATION_NS, new String[0]));
        LOGGER.debug("Open instances: {}", (Object)openInstances);
        return openInstances;
    }

    @Override
    public Set<String> getOpenInstances() {
        Set<String> openInstances = this.getOpenInstancesInternal();
        String uid = this.graph.getConfiguration().getUniqueGraphId();
        Preconditions.checkArgument((boolean)openInstances.contains(uid), (String)"Current instance [%s] not listed as an open instance: %s", (Object[])new Object[]{uid, openInstances});
        openInstances.remove(uid);
        openInstances.add(uid + CURRENT_INSTANCE_SUFFIX);
        return openInstances;
    }

    @Override
    public void forceCloseInstance(String instanceId) {
        Preconditions.checkArgument((!this.graph.getConfiguration().getUniqueGraphId().equals(instanceId) ? 1 : 0) != 0, (String)"Cannot force close this current instance [%s]. Properly shut down the graph instead.", (Object[])new Object[]{instanceId});
        Preconditions.checkArgument((boolean)this.modifyConfig.has(GraphDatabaseConfiguration.REGISTRATION_TIME, instanceId), (String)"Instance [%s] is not currently open", (Object[])new Object[]{instanceId});
        Timepoint registrationTime = this.modifyConfig.get(GraphDatabaseConfiguration.REGISTRATION_TIME, instanceId);
        Preconditions.checkArgument((registrationTime.compareTo(this.txStartTime) < 0 ? 1 : 0) != 0, (String)"The to-be-closed instance [%s] was started after this transactionwhich indicates a successful restart and can hence not be closed: %s vs %s", (Object[])new Object[]{instanceId, registrationTime, this.txStartTime});
        this.modifyConfig.remove(GraphDatabaseConfiguration.REGISTRATION_TIME, instanceId);
    }

    private void ensureOpen() {
        Preconditions.checkState((boolean)this.isOpen, (Object)"This management system instance has been closed");
    }

    @Override
    public synchronized void commit() {
        this.ensureOpen();
        if (this.transactionalConfig.hasMutations()) {
            DataOutput out = this.graph.getDataSerializer().getDataOutput(128);
            out.writeObjectNotNull((Object)MgmtLogType.CONFIG_MUTATION);
            this.transactionalConfig.logMutations(out);
            this.sysLog.add(out.getStaticBuffer());
        }
        this.transactionalConfig.commit();
        this.transaction.commit();
        if (!this.updatedTypes.isEmpty()) {
            this.mgmtLogger.sendCacheEviction(this.updatedTypes, this.updatedTypeTriggers, this.getOpenInstancesInternal());
            for (TitanSchemaVertex schemaVertex : this.updatedTypes) {
                this.schemaCache.expireSchemaElement(schemaVertex.getLongId());
            }
        }
        if (this.graphShutdownRequired) {
            this.graph.shutdown();
        }
        this.close();
    }

    @Override
    public synchronized void rollback() {
        this.ensureOpen();
        this.transactionalConfig.rollback();
        this.transaction.rollback();
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    private void close() {
        this.isOpen = false;
    }

    public StandardTitanTx getWrappedTx() {
        return this.transaction;
    }

    private TitanEdge addSchemaEdge(TitanVertex out, TitanVertex in, TypeDefinitionCategory def, Object modifier) {
        assert (def.isEdge());
        TitanEdge edge = this.transaction.addEdge(out, in, BaseLabel.SchemaDefinitionEdge);
        TypeDefinitionDescription desc = new TypeDefinitionDescription(def, modifier);
        edge.setProperty(BaseKey.SchemaDefinitionDesc, (Object)desc);
        return edge;
    }

    public TitanSchemaElement getSchemaElement(long id) {
        TitanSchemaVertex sv;
        TitanVertex v = this.transaction.getVertex(id);
        if (v == null) {
            return null;
        }
        if (v instanceof RelationType) {
            if (((InternalRelationType)v).getBaseType() == null) {
                return (RelationType)v;
            }
            return new RelationTypeIndexWrapper((InternalRelationType)v);
        }
        if (v instanceof TitanSchemaVertex && (sv = (TitanSchemaVertex)v).getDefinition().containsKey((Object)TypeDefinitionCategory.INTERNAL_INDEX)) {
            return new TitanGraphIndexWrapper(sv.asIndexType());
        }
        throw new IllegalArgumentException("Not a valid schema element vertex: " + id);
    }

    @Override
    public RelationTypeIndex buildEdgeIndex(EdgeLabel label, String name, Direction direction, RelationType ... sortKeys) {
        return this.buildEdgeIndex(label, name, direction, Order.ASC, sortKeys);
    }

    @Override
    public RelationTypeIndex buildEdgeIndex(EdgeLabel label, String name, Direction direction, Order sortOrder, RelationType ... sortKeys) {
        return this.buildRelationTypeIndex(label, name, direction, sortOrder, sortKeys);
    }

    @Override
    public RelationTypeIndex buildPropertyIndex(PropertyKey key, String name, RelationType ... sortKeys) {
        return this.buildPropertyIndex(key, name, Order.ASC, sortKeys);
    }

    @Override
    public RelationTypeIndex buildPropertyIndex(PropertyKey key, String name, Order sortOrder, RelationType ... sortKeys) {
        return this.buildRelationTypeIndex(key, name, Direction.OUT, sortOrder, sortKeys);
    }

    private RelationTypeIndex buildRelationTypeIndex(RelationType type, String name, Direction direction, Order sortOrder, RelationType ... sortKeys) {
        StandardRelationTypeMaker maker;
        StandardRelationTypeMaker lm;
        Preconditions.checkArgument((type != null && direction != null && sortOrder != null && sortKeys != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (String)"Name cannot be blank: %s", (Object[])new Object[]{name});
        Token.verifyName(name);
        Preconditions.checkArgument((sortKeys.length > 0 ? 1 : 0) != 0, (Object)"Need to specify sort keys");
        for (RelationType key : sortKeys) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Keys cannot be null");
        }
        Preconditions.checkArgument((!(type instanceof EdgeLabel) || !((EdgeLabel)type).isUnidirected() || direction == Direction.OUT ? 1 : 0) != 0, (String)"Can only index uni-directed labels in the out-direction: %s", (Object[])new Object[]{type});
        Preconditions.checkArgument((!((InternalRelationType)type).getMultiplicity().isConstrained(direction) ? 1 : 0) != 0, (String)"The relation type [%s] has a multiplicity or cardinality constraint in direction [%s] and can therefore not be indexed", (Object[])new Object[]{type, direction});
        String composedName = ManagementSystem.composeRelationTypeIndexName(type, name);
        if (type.isEdgeLabel()) {
            lm = (StandardEdgeLabelMaker)this.transaction.makeEdgeLabel(composedName);
            ((StandardEdgeLabelMaker)lm).unidirected(direction);
            maker = lm;
        } else {
            assert (type.isPropertyKey());
            assert (direction == Direction.OUT);
            lm = (StandardPropertyKeyMaker)this.transaction.makePropertyKey(composedName);
            ((StandardPropertyKeyMaker)lm).dataType((Class)((PropertyKey)type).getDataType());
            maker = lm;
        }
        maker.status(type.isNew() ? SchemaStatus.ENABLED : SchemaStatus.INSTALLED);
        maker.hidden();
        maker.multiplicity(Multiplicity.MULTI);
        maker.sortKey(sortKeys);
        maker.sortOrder(sortOrder);
        long[] typeSig = ((InternalRelationType)type).getSignature();
        HashSet signature = Sets.newHashSet();
        for (long typeId : typeSig) {
            signature.add(this.transaction.getExistingRelationType(typeId));
        }
        for (RelationType sortType : sortKeys) {
            signature.remove(sortType);
        }
        if (!signature.isEmpty()) {
            RelationType[] relationTypeArray = signature.toArray(new RelationType[signature.size()]);
            maker.signature(relationTypeArray);
        }
        RelationType relationType = maker.make();
        this.addSchemaEdge(type, relationType, TypeDefinitionCategory.RELATIONTYPE_INDEX, null);
        RelationTypeIndexWrapper index = new RelationTypeIndexWrapper((InternalRelationType)relationType);
        if (!type.isNew()) {
            this.updateIndex(index, SchemaAction.REGISTER_INDEX);
        }
        return index;
    }

    private static String composeRelationTypeIndexName(RelationType type, String name) {
        return String.valueOf(type.getLongId()) + ':' + name;
    }

    @Override
    public boolean containsRelationIndex(RelationType type, String name) {
        return this.getRelationIndex(type, name) != null;
    }

    @Override
    public RelationTypeIndex getRelationIndex(RelationType type, String name) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        String composedName = ManagementSystem.composeRelationTypeIndexName(type, name);
        TitanVertex v = (TitanVertex)Iterables.getOnlyElement(this.transaction.getVertices(BaseKey.SchemaName, (Object)TitanSchemaCategory.getRelationTypeName(composedName)), null);
        if (v == null) {
            return null;
        }
        assert (v instanceof InternalRelationType);
        return new RelationTypeIndexWrapper((InternalRelationType)v);
    }

    @Override
    public Iterable<RelationTypeIndex> getRelationIndexes(final RelationType type) {
        Preconditions.checkArgument((type != null && type instanceof InternalRelationType ? 1 : 0) != 0, (String)"Invalid relation type provided: %s", (Object[])new Object[]{type});
        return Iterables.transform((Iterable)Iterables.filter(((InternalRelationType)type).getRelationIndexes(), (Predicate)new Predicate<InternalRelationType>(){

            public boolean apply(@Nullable InternalRelationType internalRelationType) {
                return !type.equals(internalRelationType);
            }
        }), (Function)new Function<InternalRelationType, RelationTypeIndex>(){

            @Nullable
            public RelationTypeIndex apply(@Nullable InternalRelationType internalType) {
                return new RelationTypeIndexWrapper(internalType);
            }
        });
    }

    public static IndexType getGraphIndexDirect(String name, StandardTitanTx transaction) {
        TitanSchemaVertex v = transaction.getSchemaVertex(TitanSchemaCategory.GRAPHINDEX.getSchemaName(name));
        if (v == null) {
            return null;
        }
        return v.asIndexType();
    }

    @Override
    public boolean containsGraphIndex(String name) {
        return this.getGraphIndex(name) != null;
    }

    @Override
    public TitanGraphIndex getGraphIndex(String name) {
        IndexType index = ManagementSystem.getGraphIndexDirect(name, this.transaction);
        return index == null ? null : new TitanGraphIndexWrapper(index);
    }

    @Override
    public Iterable<TitanGraphIndex> getGraphIndexes(final Class<? extends Element> elementType) {
        return Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.GRAPHINDEX), (Function)new Function<TitanVertex, IndexType>(){

            @Nullable
            public IndexType apply(@Nullable TitanVertex titanVertex) {
                assert (titanVertex instanceof TitanSchemaVertex);
                return ((TitanSchemaVertex)titanVertex).asIndexType();
            }
        }), (Predicate)new Predicate<IndexType>(){

            public boolean apply(@Nullable IndexType indexType) {
                return indexType.getElement().subsumedBy(elementType);
            }
        }), (Function)new Function<IndexType, TitanGraphIndex>(){

            @Nullable
            public TitanGraphIndex apply(@Nullable IndexType indexType) {
                return new TitanGraphIndexWrapper(indexType);
            }
        });
    }

    public static boolean awaitGraphIndexStatus(TitanGraph g, String indexName, SchemaStatus status, long timeout, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull((Object)g);
        Preconditions.checkNotNull((Object)indexName);
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkArgument((0L <= timeout ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)timeoutUnit));
        HashMap<PropertyKey, SchemaStatus> notConverged = new HashMap<PropertyKey, SchemaStatus>();
        HashMap<PropertyKey, SchemaStatus> converged = new HashMap<PropertyKey, SchemaStatus>();
        Timer t = new Timer(Timestamps.MILLI).start();
        while (true) {
            boolean timedOut;
            TitanManagement mgmt = g.getManagementSystem();
            TitanGraphIndex idx = mgmt.getGraphIndex(indexName);
            for (PropertyKey pk : idx.getFieldKeys()) {
                SchemaStatus s = idx.getIndexStatus(pk);
                LOGGER.debug("Key {} has status {}", (Object)pk, (Object)s);
                if (!status.equals((Object)s)) {
                    notConverged.put(pk, s);
                    continue;
                }
                converged.put(pk, s);
            }
            String waitingOn = Joiner.on((String)",").withKeyValueSeparator("=").join(notConverged);
            mgmt.rollback();
            if (notConverged.isEmpty()) {
                LOGGER.info("All {} key(s) on index {} have status {}", new Object[]{converged.size(), indexName, status});
                return true;
            }
            LOGGER.info("Some key(s) on index {} do not currently have status {}: ", new Object[]{indexName, status, waitingOn});
            boolean bl = timedOut = timeout <= t.elapsed().getLength(timeoutUnit);
            if (timedOut) {
                LOGGER.info("Timed out ({} {}) while waiting for index {} to converge on status {}", new Object[]{timeout, timeoutUnit, indexName, status});
                return false;
            }
            notConverged.clear();
            converged.clear();
        }
    }

    private void checkIndexName(String indexName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)indexName));
        Preconditions.checkArgument((this.getGraphIndex(indexName) == null ? 1 : 0) != 0, (String)"An index with name '%s' has already been defined", (Object[])new Object[]{indexName});
    }

    private TitanGraphIndex createMixedIndex(String indexName, ElementCategory elementCategory, TitanSchemaType constraint, String backingIndex) {
        Preconditions.checkArgument((boolean)this.graph.getIndexSerializer().containsIndex(backingIndex), (String)"Unknown external index backend: %s", (Object[])new Object[]{backingIndex});
        this.checkIndexName(indexName);
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INTERNAL_INDEX, false);
        def.setValue(TypeDefinitionCategory.ELEMENT_CATEGORY, (Object)elementCategory);
        def.setValue(TypeDefinitionCategory.BACKING_INDEX, backingIndex);
        def.setValue(TypeDefinitionCategory.INDEXSTORE_NAME, indexName);
        def.setValue(TypeDefinitionCategory.INDEX_CARDINALITY, (Object)Cardinality.LIST);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)SchemaStatus.ENABLED);
        TitanSchemaVertex indexVertex = this.transaction.makeSchemaVertex(TitanSchemaCategory.GRAPHINDEX, indexName, def);
        Preconditions.checkArgument((constraint == null || elementCategory.isValidConstraint(constraint) && constraint instanceof TitanSchemaVertex ? 1 : 0) != 0);
        if (constraint != null) {
            this.addSchemaEdge(indexVertex, (TitanSchemaVertex)((Object)constraint), TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, null);
        }
        this.updateSchemaVertex(indexVertex);
        return new TitanGraphIndexWrapper(indexVertex.asIndexType());
    }

    @Override
    public void addIndexKey(TitanGraphIndex index, PropertyKey key, Parameter ... parameters) {
        Preconditions.checkArgument((index != null && key != null && index instanceof TitanGraphIndexWrapper && !(key instanceof BaseKey) ? 1 : 0) != 0, (Object)"Need to provide valid index and key");
        if (parameters == null) {
            parameters = new Parameter[]{};
        }
        IndexType indexType = ((TitanGraphIndexWrapper)index).getBaseIndex();
        Preconditions.checkArgument((boolean)(indexType instanceof MixedIndexType), (String)"Can only add keys to an external index, not %s", (Object[])new Object[]{index.getName()});
        Preconditions.checkArgument((indexType instanceof IndexTypeWrapper && key instanceof TitanSchemaVertex && ((IndexTypeWrapper)indexType).getSchemaBase() instanceof TitanSchemaVertex ? 1 : 0) != 0);
        Preconditions.checkArgument((key.getCardinality() == Cardinality.SINGLE || indexType.getElement() != ElementCategory.VERTEX ? 1 : 0) != 0, (String)"Can only index single-valued property keys on vertices [%s]", (Object[])new Object[]{key});
        TitanSchemaVertex indexVertex = (TitanSchemaVertex)((IndexTypeWrapper)indexType).getSchemaBase();
        for (IndexField field : indexType.getFieldKeys()) {
            Preconditions.checkArgument((!field.getFieldKey().equals(key) ? 1 : 0) != 0, (String)"Key [%s] has already been added to index %s", (Object[])new Object[]{key.getName(), index.getName()});
        }
        boolean addMappingParameter = !ParameterType.MAPPED_NAME.hasParameter(parameters);
        Parameter[] extendedParas = new Parameter[parameters.length + 1 + (addMappingParameter ? 1 : 0)];
        System.arraycopy(parameters, 0, extendedParas, 0, parameters.length);
        int arrPosition = parameters.length;
        if (addMappingParameter) {
            extendedParas[arrPosition++] = ParameterType.MAPPED_NAME.getParameter(this.graph.getIndexSerializer().getDefaultFieldName(key, parameters, indexType.getBackingIndexName()));
        }
        extendedParas[arrPosition++] = ParameterType.STATUS.getParameter(key.isNew() ? SchemaStatus.ENABLED : SchemaStatus.INSTALLED);
        this.addSchemaEdge(indexVertex, key, TypeDefinitionCategory.INDEX_FIELD, extendedParas);
        this.updateSchemaVertex(indexVertex);
        indexType.resetCache();
        try {
            IndexSerializer.register((MixedIndexType)indexType, key, this.transaction.getTxHandle());
        }
        catch (BackendException e) {
            throw new TitanException("Could not register new index field with index backend", e);
        }
        if (!indexVertex.isNew()) {
            this.updatedTypes.add(indexVertex);
        }
        if (!key.isNew()) {
            this.updateIndex(index, SchemaAction.REGISTER_INDEX);
        }
    }

    private TitanGraphIndex createCompositeIndex(String indexName, ElementCategory elementCategory, boolean unique, TitanSchemaType constraint, PropertyKey ... keys) {
        this.checkIndexName(indexName);
        Preconditions.checkArgument((keys != null && keys.length > 0 ? 1 : 0) != 0, (String)"Need to provide keys to index [%s]", (Object[])new Object[]{indexName});
        Preconditions.checkArgument((!unique || elementCategory == ElementCategory.VERTEX ? 1 : 0) != 0, (String)"Unique indexes can only be created on vertices [%s]", (Object[])new Object[]{indexName});
        boolean allSingleKeys = true;
        boolean oneNewKey = false;
        for (PropertyKey key : keys) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Need to provide valid keys: %s", (Object[])new Object[]{key});
            if (key.getCardinality() != Cardinality.SINGLE) {
                allSingleKeys = false;
            }
            if (key.isNew()) {
                oneNewKey = true;
                continue;
            }
            this.updatedTypes.add((PropertyKeyVertex)key);
        }
        Cardinality indexCardinality = unique ? Cardinality.SINGLE : (allSingleKeys ? Cardinality.SET : Cardinality.LIST);
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INTERNAL_INDEX, true);
        def.setValue(TypeDefinitionCategory.ELEMENT_CATEGORY, (Object)elementCategory);
        def.setValue(TypeDefinitionCategory.BACKING_INDEX, "internalindex");
        def.setValue(TypeDefinitionCategory.INDEXSTORE_NAME, indexName);
        def.setValue(TypeDefinitionCategory.INDEX_CARDINALITY, (Object)indexCardinality);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)(oneNewKey ? SchemaStatus.ENABLED : SchemaStatus.INSTALLED));
        TitanSchemaVertex indexVertex = this.transaction.makeSchemaVertex(TitanSchemaCategory.GRAPHINDEX, indexName, def);
        for (int i = 0; i < keys.length; ++i) {
            Parameter[] paras = new Parameter[]{ParameterType.INDEX_POSITION.getParameter(i)};
            this.addSchemaEdge(indexVertex, keys[i], TypeDefinitionCategory.INDEX_FIELD, paras);
        }
        Preconditions.checkArgument((constraint == null || elementCategory.isValidConstraint(constraint) && constraint instanceof TitanSchemaVertex ? 1 : 0) != 0);
        if (constraint != null) {
            this.addSchemaEdge(indexVertex, (TitanSchemaVertex)((Object)constraint), TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, null);
        }
        this.updateSchemaVertex(indexVertex);
        TitanGraphIndexWrapper index = new TitanGraphIndexWrapper(indexVertex.asIndexType());
        if (!oneNewKey) {
            this.updateIndex(index, SchemaAction.REGISTER_INDEX);
        }
        return index;
    }

    @Override
    public TitanManagement.IndexBuilder buildIndex(String indexName, Class<? extends Element> elementType) {
        return new IndexBuilder(indexName, ElementCategory.getByClazz(elementType));
    }

    @Override
    public void updateIndex(TitanIndex index, SchemaAction updateAction) {
        Object dependentTypes;
        Preconditions.checkArgument((updateAction != null ? 1 : 0) != 0, (Object)"Need to provide update action");
        Preconditions.checkArgument((updateAction != SchemaAction.REMOVE_INDEX ? 1 : 0) != 0);
        TitanSchemaVertex schemaVertex = this.getSchemaVertex(index);
        Object keySubset = ImmutableSet.of();
        if (index instanceof RelationTypeIndex) {
            dependentTypes = ImmutableSet.of((Object)((TitanSchemaVertex)((Object)((InternalRelationType)((Object)schemaVertex)).getBaseType())));
            Preconditions.checkArgument((boolean)updateAction.getApplicableStatus().contains((Object)schemaVertex.getStatus()), (String)"Update action [%s] does not apply for index with status [%s]", (Object[])new Object[]{updateAction, schemaVertex.getStatus()});
        } else if (index instanceof TitanGraphIndex) {
            IndexType indexType = schemaVertex.asIndexType();
            dependentTypes = Sets.newHashSet();
            if (indexType.isCompositeIndex()) {
                Preconditions.checkArgument((boolean)updateAction.getApplicableStatus().contains((Object)schemaVertex.getStatus()), (String)"Update action [%s] does not apply for index with status [%s]", (Object[])new Object[]{updateAction, schemaVertex.getStatus()});
                for (PropertyKey key : ((TitanGraphIndex)index).getFieldKeys()) {
                    dependentTypes.add((PropertyKeyVertex)key);
                }
            } else {
                keySubset = Sets.newHashSet();
                MixedIndexType cindexType = (MixedIndexType)indexType;
                Set<SchemaStatus> applicableStatus = updateAction.getApplicableStatus();
                for (ParameterIndexField field : cindexType.getFieldKeys()) {
                    if (!applicableStatus.contains((Object)field.getStatus())) continue;
                    keySubset.add((PropertyKeyVertex)field.getFieldKey());
                }
                Preconditions.checkArgument((!keySubset.isEmpty() ? 1 : 0) != 0, (String)"Update action [%s] does not apply to any fields for index [%s]", (Object[])new Object[]{updateAction, index});
                dependentTypes.addAll(keySubset);
            }
        } else {
            throw new UnsupportedOperationException("Updates not supported for index: " + index);
        }
        switch (updateAction) {
            case REGISTER_INDEX: {
                this.setStatus(schemaVertex, SchemaStatus.INSTALLED, (Set<PropertyKeyVertex>)keySubset);
                this.updatedTypes.add(schemaVertex);
                this.updatedTypes.addAll((Collection<TitanSchemaVertex>)dependentTypes);
                this.setUpdateTrigger(new UpdateStatusTrigger(this.graph, schemaVertex, SchemaStatus.REGISTERED, (Iterable)keySubset));
                break;
            }
            case REINDEX: {
                throw new UnsupportedOperationException((Object)((Object)updateAction) + " requires a manual step: run a MapReduce reindex on index name \"" + index.getName() + "\"");
            }
            case ENABLE_INDEX: {
                this.setStatus(schemaVertex, SchemaStatus.ENABLED, (Set<PropertyKeyVertex>)keySubset);
                this.updatedTypes.add(schemaVertex);
                if (keySubset.isEmpty()) break;
                this.updatedTypes.addAll((Collection<TitanSchemaVertex>)dependentTypes);
                break;
            }
            case DISABLE_INDEX: {
                this.setStatus(schemaVertex, SchemaStatus.INSTALLED, (Set<PropertyKeyVertex>)keySubset);
                this.updatedTypes.add(schemaVertex);
                if (!keySubset.isEmpty()) {
                    this.updatedTypes.addAll((Collection<TitanSchemaVertex>)dependentTypes);
                }
                this.setUpdateTrigger(new UpdateStatusTrigger(this.graph, schemaVertex, SchemaStatus.DISABLED, (Iterable)keySubset));
                break;
            }
            case REMOVE_INDEX: {
                throw new UnsupportedOperationException("Removing indexes is not yet supported");
            }
            default: {
                throw new UnsupportedOperationException("Update action not supported: " + (Object)((Object)updateAction));
            }
        }
    }

    private void setUpdateTrigger(Callable<Boolean> trigger) {
        if (this.updatedTypeTriggers.contains(trigger)) {
            this.updatedTypeTriggers.remove(trigger);
        }
        this.updatedTypeTriggers.add(trigger);
    }

    private void setStatus(TitanSchemaVertex vertex, SchemaStatus status, Set<PropertyKeyVertex> keys) {
        if (keys.isEmpty()) {
            this.setStatusVertex(vertex, status);
        } else {
            this.setStatusEdges(vertex, status, keys);
        }
        vertex.resetCache();
        this.updateSchemaVertex(vertex);
    }

    private void setStatusVertex(TitanSchemaVertex vertex, SchemaStatus status) {
        Preconditions.checkArgument((vertex instanceof RelationTypeVertex || vertex.asIndexType().isCompositeIndex() ? 1 : 0) != 0);
        for (TitanProperty p : vertex.getProperties(BaseKey.SchemaDefinitionProperty)) {
            if (((TypeDefinitionDescription)p.getProperty(BaseKey.SchemaDefinitionDesc)).getCategory() != TypeDefinitionCategory.STATUS) continue;
            if (p.getValue().equals((Object)status)) {
                return;
            }
            p.remove();
        }
        TitanProperty p = this.transaction.addProperty((TitanVertex)vertex, BaseKey.SchemaDefinitionProperty, (Object)status);
        p.setProperty(BaseKey.SchemaDefinitionDesc, (Object)TypeDefinitionDescription.of(TypeDefinitionCategory.STATUS));
    }

    private void setStatusEdges(TitanSchemaVertex vertex, SchemaStatus status, Set<PropertyKeyVertex> keys) {
        Preconditions.checkArgument((boolean)vertex.asIndexType().isMixedIndex());
        for (TitanEdge edge : vertex.getEdges(TypeDefinitionCategory.INDEX_FIELD, Direction.OUT)) {
            if (!keys.contains(edge.getVertex(Direction.IN))) continue;
            TypeDefinitionDescription desc = (TypeDefinitionDescription)edge.getProperty(BaseKey.SchemaDefinitionDesc);
            assert (desc.getCategory() == TypeDefinitionCategory.INDEX_FIELD);
            Parameter[] parameters = (Parameter[])desc.getModifier();
            assert (parameters[parameters.length - 1].getKey().equals(ParameterType.STATUS.getName()));
            if (parameters[parameters.length - 1].getValue().equals((Object)status)) continue;
            Parameter[] paraCopy = Arrays.copyOf(parameters, parameters.length);
            paraCopy[parameters.length - 1] = ParameterType.STATUS.getParameter(status);
            edge.remove();
            this.addSchemaEdge(vertex, edge.getVertex(Direction.IN), TypeDefinitionCategory.INDEX_FIELD, paraCopy);
        }
        for (PropertyKeyVertex prop : keys) {
            prop.resetCache();
        }
    }

    @Override
    public void changeName(TitanSchemaElement element, String newName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)newName), (String)"Invalid name: %s", (Object[])new Object[]{newName});
        TitanSchemaVertex schemaVertex = this.getSchemaVertex(element);
        if (schemaVertex.getName().equals(newName)) {
            return;
        }
        TitanSchemaCategory schemaCategory = (TitanSchemaCategory)((Object)schemaVertex.getProperty(BaseKey.SchemaCategory));
        Preconditions.checkArgument((boolean)schemaCategory.hasName(), (String)"Invalid schema element: %s", (Object[])new Object[]{element});
        if (schemaVertex instanceof RelationType) {
            InternalRelationType relType = (InternalRelationType)((Object)schemaVertex);
            if (relType.getBaseType() != null) {
                newName = ManagementSystem.composeRelationTypeIndexName(relType.getBaseType(), newName);
            } else assert (!(element instanceof RelationTypeIndex));
            StandardRelationTypeMaker.checkName(newName);
        } else if (element instanceof VertexLabel) {
            StandardVertexLabelMaker.checkName(newName);
        } else if (element instanceof TitanGraphIndex) {
            this.checkIndexName(newName);
        }
        this.transaction.addProperty((TitanVertex)schemaVertex, BaseKey.SchemaName, (Object)schemaCategory.getSchemaName(newName));
        this.updateSchemaVertex(schemaVertex);
        schemaVertex.resetCache();
        this.updatedTypes.add(schemaVertex);
    }

    public TitanSchemaVertex getSchemaVertex(TitanSchemaElement element) {
        if (element instanceof RelationType) {
            Preconditions.checkArgument((boolean)(element instanceof RelationTypeVertex), (String)"Invalid schema element provided: %s", (Object[])new Object[]{element});
            return (RelationTypeVertex)element;
        }
        if (element instanceof RelationTypeIndex) {
            return (RelationTypeVertex)((RelationTypeIndexWrapper)element).getWrappedType();
        }
        if (element instanceof VertexLabel) {
            Preconditions.checkArgument((boolean)(element instanceof VertexLabelVertex), (String)"Invalid schema element provided: %s", (Object[])new Object[]{element});
            return (VertexLabelVertex)element;
        }
        if (element instanceof TitanGraphIndex) {
            Preconditions.checkArgument((boolean)(element instanceof TitanGraphIndexWrapper), (String)"Invalid schema element provided: %s", (Object[])new Object[]{element});
            IndexType index = ((TitanGraphIndexWrapper)element).getBaseIndex();
            assert (index instanceof IndexTypeWrapper);
            SchemaSource base = ((IndexTypeWrapper)index).getSchemaBase();
            assert (base instanceof TitanSchemaVertex);
            return (TitanSchemaVertex)base;
        }
        throw new IllegalArgumentException("Invalid schema element provided: " + element);
    }

    private void updateSchemaVertex(TitanSchemaVertex schemaVertex) {
        this.transaction.updateSchemaVertex(schemaVertex);
    }

    @Override
    public ConsistencyModifier getConsistency(TitanSchemaElement element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0);
        if (element instanceof RelationType) {
            return ((InternalRelationType)element).getConsistencyModifier();
        }
        if (element instanceof TitanGraphIndex) {
            IndexType index = ((TitanGraphIndexWrapper)element).getBaseIndex();
            if (index.isMixedIndex()) {
                return ConsistencyModifier.DEFAULT;
            }
            return ((CompositeIndexType)index).getConsistencyModifier();
        }
        return ConsistencyModifier.DEFAULT;
    }

    @Override
    public void setConsistency(TitanSchemaElement element, ConsistencyModifier consistency) {
        if (element instanceof RelationType) {
            RelationTypeVertex rv = (RelationTypeVertex)element;
            Preconditions.checkArgument((consistency != ConsistencyModifier.FORK || !rv.getMultiplicity().isConstrained() ? 1 : 0) != 0, (String)"Cannot apply FORK consistency mode to constraint relation type: %s", (Object[])new Object[]{rv.getName()});
        } else if (element instanceof TitanGraphIndex) {
            IndexType index = ((TitanGraphIndexWrapper)element).getBaseIndex();
            if (index.isMixedIndex()) {
                throw new IllegalArgumentException("Cannot change consistency on mixed index: " + element);
            }
        } else {
            throw new IllegalArgumentException("Cannot change consistency of schema element: " + element);
        }
        this.setTypeModifier(element, ModifierType.CONSISTENCY, (Object)consistency);
    }

    @Override
    public Duration getTTL(TitanSchemaType type) {
        int ttl;
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        if (type instanceof VertexLabelVertex) {
            ttl = ((VertexLabelVertex)type).getTTL();
        } else if (type instanceof RelationTypeVertex) {
            ttl = ((RelationTypeVertex)type).getTTL();
        } else {
            throw new IllegalArgumentException("given type does not support TTL: " + type.getClass());
        }
        return new StandardDuration(ttl, TimeUnit.SECONDS);
    }

    @Override
    public void setTTL(TitanSchemaType type, int ttl, TimeUnit unit) {
        if (!this.graph.getBackend().getStoreFeatures().hasCellTTL()) {
            throw new UnsupportedOperationException("The storage engine does not support TTL");
        }
        if (type instanceof VertexLabelVertex) {
            Preconditions.checkArgument((boolean)((VertexLabelVertex)type).isStatic(), (Object)"must define vertex label as static to allow setting TTL");
        } else {
            Preconditions.checkArgument((type instanceof EdgeLabelVertex || type instanceof PropertyKeyVertex ? 1 : 0) != 0, (Object)("TTL is not supported for type " + type.getClass().getSimpleName()));
        }
        Preconditions.checkArgument((boolean)(type instanceof TitanSchemaVertex));
        this.setTypeModifier(type, ModifierType.TTL, ConversionHelper.getTTLSeconds(ttl, unit));
    }

    private void setTypeModifier(TitanSchemaElement element, ModifierType modifierType, Object value) {
        TitanSchemaVertex typeVertex;
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (Object)"null schema element");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("null value for type modifier " + (Object)((Object)modifierType)));
        TypeDefinitionCategory cat = modifierType.getCategory();
        if (cat.hasDataType()) {
            Preconditions.checkArgument((boolean)cat.getDataType().equals(value.getClass()), (Object)("modifier value is not of expected type " + cat.getDataType()));
        }
        if (element instanceof TitanSchemaVertex) {
            typeVertex = (TitanSchemaVertex)((Object)element);
        } else if (element instanceof TitanGraphIndex) {
            IndexType index = ((TitanGraphIndexWrapper)element).getBaseIndex();
            assert (index instanceof IndexTypeWrapper);
            SchemaSource base = ((IndexTypeWrapper)index).getSchemaBase();
            typeVertex = (TitanSchemaVertex)base;
        } else {
            throw new IllegalArgumentException("Invalid schema element: " + element);
        }
        for (TitanEdge e : typeVertex.getEdges(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT)) {
            TitanSchemaVertex v = (TitanSchemaVertex)e.getVertex(Direction.IN);
            TypeDefinitionMap def = v.getDefinition();
            Object existingValue = def.getValue(modifierType.getCategory());
            if (null == existingValue) continue;
            if (existingValue.equals(value)) {
                return;
            }
            e.remove();
            v.remove();
        }
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(cat, value);
        TitanSchemaVertex cVertex = this.transaction.makeSchemaVertex(TitanSchemaCategory.TYPE_MODIFIER, null, def);
        this.addSchemaEdge(typeVertex, cVertex, TypeDefinitionCategory.TYPE_MODIFIER, null);
        this.updateSchemaVertex(typeVertex);
        this.updatedTypes.add(typeVertex);
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.transaction.containsRelationType(name);
    }

    @Override
    public RelationType getRelationType(String name) {
        return this.transaction.getRelationType(name);
    }

    @Override
    public boolean containsPropertyKey(String name) {
        return this.transaction.containsPropertyKey(name);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        return this.transaction.getPropertyKey(name);
    }

    @Override
    public boolean containsEdgeLabel(String name) {
        return this.transaction.containsEdgeLabel(name);
    }

    @Override
    public EdgeLabel getOrCreateEdgeLabel(String name) {
        return this.transaction.getOrCreateEdgeLabel(name);
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name) {
        return this.transaction.getOrCreatePropertyKey(name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        return this.transaction.getEdgeLabel(name);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        return this.transaction.makePropertyKey(name);
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        return this.transaction.makeEdgeLabel(name);
    }

    @Override
    public <T extends RelationType> Iterable<T> getRelationTypes(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        Iterable types = null;
        if (PropertyKey.class.equals(clazz)) {
            types = this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.PROPERTYKEY);
        } else if (EdgeLabel.class.equals(clazz)) {
            types = this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.EDGELABEL);
        } else if (RelationType.class.equals(clazz)) {
            types = Iterables.concat(this.getRelationTypes(EdgeLabel.class), this.getRelationTypes(PropertyKey.class));
        } else {
            throw new IllegalArgumentException("Unknown type class: " + clazz);
        }
        return Iterables.filter((Iterable)Iterables.filter(types, clazz), (Predicate)new Predicate<T>(){

            public boolean apply(@Nullable T t) {
                return ((InternalRelationType)t).getBaseType() == null;
            }
        });
    }

    @Override
    public boolean containsVertexLabel(String name) {
        return this.transaction.containsVertexLabel(name);
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        return this.transaction.getVertexLabel(name);
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        return this.transaction.makeVertexLabel(name);
    }

    @Override
    public Iterable<VertexLabel> getVertexLabels() {
        return Iterables.filter(this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.VERTEXLABEL), VertexLabel.class);
    }

    @Override
    public synchronized String get(String path) {
        this.ensureOpen();
        return this.userConfig.get(path);
    }

    @Override
    public synchronized TitanConfiguration set(String path, Object value) {
        this.ensureOpen();
        return this.userConfig.set(path, value);
    }

    private static class UpdateStatusTrigger
    implements Callable<Boolean> {
        private static final Logger log = LoggerFactory.getLogger(UpdateStatusTrigger.class);
        private final StandardTitanGraph graph;
        private final long schemaVertexId;
        private final SchemaStatus newStatus;
        private final Set<Long> propertyKeys;

        private UpdateStatusTrigger(StandardTitanGraph graph, TitanSchemaVertex vertex, SchemaStatus newStatus, Iterable<PropertyKeyVertex> keys) {
            this.graph = graph;
            this.schemaVertexId = vertex.getLongId();
            this.newStatus = newStatus;
            this.propertyKeys = Sets.newHashSet((Iterable)Iterables.transform(keys, (Function)new Function<PropertyKey, Long>(){

                @Nullable
                public Long apply(@Nullable PropertyKey propertyKey) {
                    return propertyKey.getLongId();
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean call() throws Exception {
            ManagementSystem mgmt = (ManagementSystem)this.graph.getManagementSystem();
            try {
                TitanVertex vertex = mgmt.transaction.getVertex(this.schemaVertexId);
                Preconditions.checkArgument((vertex != null && vertex instanceof TitanSchemaVertex ? 1 : 0) != 0);
                TitanSchemaVertex schemaVertex = (TitanSchemaVertex)vertex;
                HashSet keys = Sets.newHashSet();
                for (Long l : this.propertyKeys) {
                    keys.add((PropertyKeyVertex)mgmt.transaction.getVertex(l));
                }
                mgmt.setStatus(schemaVertex, this.newStatus, keys);
                mgmt.updatedTypes.addAll(keys);
                mgmt.updatedTypes.add(schemaVertex);
                if (log.isInfoEnabled()) {
                    void var6_11;
                    HashSet propNames = Sets.newHashSet();
                    for (PropertyKeyVertex v : keys) {
                        try {
                            propNames.add(v.getName());
                        }
                        catch (Throwable t) {
                            log.warn("Failed to get name for property key with id {}", (Object)v.getLongId(), (Object)t);
                            propNames.add("(ID#" + v.getLongId() + ")");
                        }
                    }
                    String string = "(ID#" + this.schemaVertexId + ")";
                    try {
                        String string2 = schemaVertex.getName();
                    }
                    catch (Throwable t) {
                        log.warn("Failed to get name for schema vertex with id {}", (Object)this.schemaVertexId, (Object)t);
                    }
                    log.info("Set status {} on schema element {} with property keys {}", new Object[]{this.newStatus, var6_11, propNames});
                }
                mgmt.commit();
                return true;
            }
            catch (RuntimeException e) {
                mgmt.rollback();
                throw e;
            }
        }

        public int hashCode() {
            return Long.valueOf(this.schemaVertexId).hashCode();
        }

        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null || !this.getClass().isInstance(oth)) {
                return false;
            }
            return this.schemaVertexId == ((UpdateStatusTrigger)oth).schemaVertexId;
        }
    }

    private class IndexBuilder
    implements TitanManagement.IndexBuilder {
        private final String indexName;
        private final ElementCategory elementCategory;
        private boolean unique = false;
        private TitanSchemaType constraint = null;
        private Map<PropertyKey, Parameter[]> keys = new HashMap<PropertyKey, Parameter[]>();

        private IndexBuilder(String indexName, ElementCategory elementCategory) {
            this.indexName = indexName;
            this.elementCategory = elementCategory;
        }

        @Override
        public TitanManagement.IndexBuilder addKey(PropertyKey key) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object[])new Object[]{key});
            this.keys.put(key, null);
            return this;
        }

        @Override
        public TitanManagement.IndexBuilder addKey(PropertyKey key, Parameter ... parameters) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object[])new Object[]{key});
            this.keys.put(key, parameters);
            return this;
        }

        @Override
        public TitanManagement.IndexBuilder indexOnly(TitanSchemaType schemaType) {
            Preconditions.checkNotNull((Object)schemaType);
            Preconditions.checkArgument((boolean)this.elementCategory.isValidConstraint(schemaType), (String)"Need to specify a valid schema type for this index definition: %s", (Object[])new Object[]{schemaType});
            this.constraint = schemaType;
            return this;
        }

        @Override
        public TitanManagement.IndexBuilder unique() {
            this.unique = true;
            return this;
        }

        @Override
        public TitanGraphIndex buildCompositeIndex() {
            Preconditions.checkArgument((!this.keys.isEmpty() ? 1 : 0) != 0, (Object)"Need to specify at least one key for the composite index");
            PropertyKey[] keyArr = new PropertyKey[this.keys.size()];
            int pos = 0;
            for (Map.Entry<PropertyKey, Parameter[]> entry : this.keys.entrySet()) {
                Preconditions.checkArgument((entry.getValue() == null ? 1 : 0) != 0, (String)"Cannot specify parameters for composite index: %s", (Object[])new Object[]{entry.getKey()});
                keyArr[pos++] = entry.getKey();
            }
            return ManagementSystem.this.createCompositeIndex(this.indexName, this.elementCategory, this.unique, this.constraint, keyArr);
        }

        @Override
        public TitanGraphIndex buildMixedIndex(String backingIndex) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)backingIndex), (Object)"Need to specify backing index name");
            Preconditions.checkArgument((!this.unique ? 1 : 0) != 0, (Object)"An external index cannot be unique");
            TitanGraphIndex index = ManagementSystem.this.createMixedIndex(this.indexName, this.elementCategory, this.constraint, backingIndex);
            for (Map.Entry<PropertyKey, Parameter[]> entry : this.keys.entrySet()) {
                ManagementSystem.this.addIndexKey(index, entry.getKey(), entry.getValue());
            }
            return index;
        }
    }
}

