/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.util.Optional;
import java.util.Set;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.api.ReplicationDestination;
import org.apache.asterix.replication.management.IndexReplicationManager;
import org.apache.asterix.replication.sync.IndexSynchronizer;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractIoOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.NoOpIOOperationCallbackFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationOperation
extends AbstractIoOperation {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ILSMIOOperationCallback INSTANCE = NoOpIOOperationCallbackFactory.INSTANCE.createIoOpCallback(null);
    private final INcApplicationContext appCtx;
    private final DatasetResourceReference indexRef;
    private final IReplicationJob job;
    private final IndexReplicationManager indexReplicationManager;

    public ReplicationOperation(INcApplicationContext appCtx, DatasetResourceReference indexRef, IReplicationJob job, IndexReplicationManager indexReplicationManager) {
        super(null, null, INSTANCE, indexRef.getRelativePath().toString());
        this.appCtx = appCtx;
        this.indexRef = indexRef;
        this.job = job;
        this.indexReplicationManager = indexReplicationManager;
    }

    public ILSMIOOperation.LSMIOOperationType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOperationType.REPLICATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMIOOperation.LSMIOOperationStatus call() {
        try {
            Set<ReplicationDestination> destinations = this.indexReplicationManager.getDestinations();
            if (destinations.isEmpty() || this.indexReplicationManager.skip(this.indexRef)) {
                ILSMIOOperation.LSMIOOperationStatus lSMIOOperationStatus = ILSMIOOperation.LSMIOOperationStatus.SUCCESS;
                return lSMIOOperationStatus;
            }
            LOGGER.debug("started replicate operation on index {}", (Object)this.indexRef);
            IndexSynchronizer synchronizer = new IndexSynchronizer(this.job, this.appCtx);
            int indexPartition = this.indexRef.getPartitionId();
            for (ReplicationDestination dest : destinations) {
                Optional<IPartitionReplica> partitionReplica = dest.getPartitionReplica(indexPartition);
                if (partitionReplica.isEmpty()) continue;
                PartitionReplica destReplica = null;
                try {
                    destReplica = dest.getPartitionReplicaConnection(partitionReplica.get().getIdentifier(), this.appCtx);
                    synchronizer.sync(destReplica);
                    dest.recycleConnection(destReplica);
                }
                catch (Exception e) {
                    if (destReplica != null) {
                        destReplica.close();
                    }
                    this.indexReplicationManager.handleFailure(dest, e);
                }
            }
            LOGGER.debug("completed replicate operation on index {}", (Object)this.indexRef);
            ILSMIOOperation.LSMIOOperationStatus lSMIOOperationStatus = ILSMIOOperation.LSMIOOperationStatus.SUCCESS;
            return lSMIOOperationStatus;
        }
        finally {
            this.indexReplicationManager.afterReplication(this.job);
        }
    }

    protected LSMComponentFileReferences getComponentFiles() {
        return null;
    }

    public long getRemainingPages() {
        return 0L;
    }
}

