/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.comm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.apache.hyracks.api.io.IWritable;

public final class NetworkAddress
implements IWritable,
Serializable {
    private static final long serialVersionUID = 2L;
    private String address;
    private volatile byte[] ipAddress;
    private int port;

    public static NetworkAddress create(DataInput dis) throws IOException {
        NetworkAddress networkAddress = new NetworkAddress();
        networkAddress.readFields(dis);
        return networkAddress;
    }

    private NetworkAddress() {
        this.ipAddress = null;
    }

    public NetworkAddress(String address, int port) {
        this.address = address;
        this.port = port;
        this.ipAddress = null;
    }

    public NetworkAddress(InetSocketAddress socketAddress) {
        this.address = socketAddress.getHostString();
        this.port = socketAddress.getPort();
        if (!socketAddress.isUnresolved()) {
            this.ipAddress = socketAddress.getAddress().getAddress();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public byte[] lookupIpAddress() throws UnknownHostException {
        if (this.ipAddress == null) {
            InetAddress addr = InetAddress.getByName(this.address);
            this.ipAddress = addr.getAddress();
        }
        return this.ipAddress;
    }

    public InetSocketAddress toResolvedInetSocketAddress() throws UnknownHostException {
        InetSocketAddress addr = this.toInetSocketAddress();
        if (addr.isUnresolved()) {
            throw new UnknownHostException(this.getAddress());
        }
        return addr;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.address, this.port);
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.address + ":" + this.port;
    }

    public int hashCode() {
        return this.address.hashCode() + this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetworkAddress)) {
            return false;
        }
        NetworkAddress on = (NetworkAddress)o;
        return on.port == this.port && Objects.equals(on.address, this.address);
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeUTF(this.address);
        output.writeInt(this.port);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.address = input.readUTF();
        this.port = input.readInt();
    }
}

