/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class Checkpoint
implements Comparable<Checkpoint>,
IJsonSerializable {
    private static final long serialVersionUID = 1L;
    private final long checkpointLsn;
    private final long minMCTFirstLsn;
    private final long maxTxnId;
    private final boolean sharp;
    private final int storageVersion;
    private long id;

    public Checkpoint(long id, long checkpointLsn, long minMCTFirstLsn, long maxTxnId, boolean sharp, int storageVersion) {
        this.id = id;
        this.checkpointLsn = checkpointLsn;
        this.minMCTFirstLsn = minMCTFirstLsn;
        this.maxTxnId = maxTxnId;
        this.sharp = sharp;
        this.storageVersion = storageVersion;
    }

    public long getCheckpointLsn() {
        return this.checkpointLsn;
    }

    public long getMinMCTFirstLsn() {
        return this.minMCTFirstLsn;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSharp() {
        return this.sharp;
    }

    public int getStorageVersion() {
        return this.storageVersion;
    }

    @Override
    public int compareTo(Checkpoint other) {
        return Long.compare(this.id, other.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode checkpointJson = registry.getClassIdentifier(this.getClass(), 1L);
        checkpointJson.put("id", this.id);
        checkpointJson.put("checkpointLsn", this.checkpointLsn);
        checkpointJson.put("minMCTFirstLsn", this.minMCTFirstLsn);
        checkpointJson.put("maxTxnId", this.maxTxnId);
        checkpointJson.put("sharp", this.sharp);
        checkpointJson.put("storageVersion", this.storageVersion);
        return checkpointJson;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        long id = json.get("id").asLong();
        long checkpointLsn = json.get("checkpointLsn").asLong();
        long minMCTFirstLsn = json.get("minMCTFirstLsn").asLong();
        long maxTxnId = json.get("maxTxnId").asLong();
        boolean sharp = json.get("sharp").asBoolean();
        int storageVersion = json.get("storageVersion").asInt();
        return new Checkpoint(id, checkpointLsn, minMCTFirstLsn, maxTxnId, sharp, storageVersion);
    }
}

