/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.event.metrics;

import com.couchbase.client.core.event.metrics.LatencyMetric;
import com.couchbase.client.core.event.metrics.LatencyMetricsEvent;
import com.couchbase.client.core.metrics.NetworkLatencyMetricsIdentifier;
import com.couchbase.client.core.utils.Events;
import java.util.HashMap;
import java.util.Map;

public class NetworkLatencyMetricsEvent
extends LatencyMetricsEvent<NetworkLatencyMetricsIdentifier> {
    public NetworkLatencyMetricsEvent(Map<NetworkLatencyMetricsIdentifier, LatencyMetric> latencies) {
        super(latencies);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = Events.identityMap(this);
        for (Map.Entry metric : this.latencies().entrySet()) {
            NetworkLatencyMetricsIdentifier ident = (NetworkLatencyMetricsIdentifier)metric.getKey();
            Map<String, Object> host = this.getOrCreate(ident.host(), result);
            Map<String, Object> service = this.getOrCreate(ident.service(), host);
            Map<String, Object> request = this.getOrCreate(ident.request(), service);
            Map<String, Object> status = this.getOrCreate(ident.status(), request);
            status.put("metrics", metric.getValue().export());
        }
        return result;
    }

    private Map<String, Object> getOrCreate(String key, Map<String, Object> source) {
        HashMap found = (HashMap)source.get(key);
        if (found == null) {
            found = new HashMap();
            source.put(key, found);
        }
        return found;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("NetworkLatencyMetricsEvent");
        sb.append(this.toMap().toString());
        return sb.toString();
    }
}

